// umanagedExample.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include <iostream>
#include <windows.h>

//To get a tlb file from STSeries.dll, run "gacutil -i STSeries.dll" then "regasm STSeries.dll /tlb"
//then update the import to the correct path.
#import "STSeries.tlb" no_namespace named_guids

using namespace std;

//This is required or callbacks fail with an AccessViolation.  It is a special global ATL uses.
CComModule _Module;

const UINT IDSCRIPTEL = 42;

class CEventHandler : public IDispEventImpl<IDSCRIPTEL, CEventHandler, &DIID_IUnmanagedEvents, &LIBID_STSeries, 2, 5>
{
public:
	BEGIN_SINK_MAP(CEventHandler)
		SINK_ENTRY_EX(IDSCRIPTEL, DIID_IUnmanagedEvents, 0x1, ContainerEvent)
		SINK_ENTRY_EX(IDSCRIPTEL, DIID_IUnmanagedEvents, 0x2, ButtonEvent)
		SINK_ENTRY_EX(IDSCRIPTEL, DIID_IUnmanagedEvents, 0x3, DownloadStatusEvent)
	    SINK_ENTRY_EX(IDSCRIPTEL, DIID_IUnmanagedEvents, 0x4, UnpluggedEvent)
		SINK_ENTRY_EX(IDSCRIPTEL, DIID_IUnmanagedEvents, 0x5, CardSwipedEvent)
	END_SINK_MAP()

	HRESULT __stdcall ContainerEvent(_variant_t pt, IRegionSelectedEventArgsPtr e)
	{
		ATLTRACE("ContainerEvent event\n");
		ISTSignaturePointPtr point = e->GetsigPoint();

		cout << "Pen at " << point->GetX() << " " << point->GetY() << " " << e->GetregionNumber() << " switch status " << point->SwitchStatus <<  endl;
		return S_OK;
	}

	HRESULT __stdcall ButtonEvent(_variant_t pt, IRegionSelectedEventArgsPtr e)
	{
		ATLTRACE("ButtonEvent event\n");
		ISTSignaturePointPtr point = e->GetsigPoint();

		cout << "Pen at " << point->GetX() << " " << point->GetY() << " " << e->GetregionNumber() <<  endl;
		return S_OK;
	}

	HRESULT __stdcall DownloadStatusEvent(_variant_t pt, IFirmwareDownloadStatusEventArgsPtr e){
		cout << "Firmware status: " << e->GetPercentComplete() << endl;
		return S_OK;
	}

	HRESULT __stdcall UnpluggedEvent(_variant_t pt, _EventArgs * e){
		cout << "Unplugged event: " << ((ISTSeriesDevicePtr)pt.pdispVal)->DeviceName << endl;
		return S_OK;
	}

	HRESULT __stdcall CardSwipedEvent(_variant_t pt, ICardSwipedEventArgsPtr e) {
		cout << "Card Swipe event: " << e->GetTrackOneContent() << endl;
		return S_OK;
	}

};

int _tmain(int argc, _TCHAR* argv[])
{
	CoInitialize(NULL);   //Initialize all COM Components
  
	ISTSeriesDevicesManager *cpi = NULL;

	HRESULT hr = CoCreateInstance(CLSID_STSeriesDevicesManager,
               NULL, CLSCTX_INPROC_SERVER,
               IID_ISTSeriesDevicesManager, reinterpret_cast<void**>(&cpi));

	int numOfDevices = cpi->GetNumberOfSTSeriesDevices();

	ISTSeriesDevicePtr device = cpi->GetSTSeriesDevice(0);

	std::cout << device->DeviceName << std::endl;

	device->Open();

	IUnknownPtr spUnknown = device;
	CEventHandler* eventHandler = new CEventHandler();
	hr = eventHandler->DispEventAdvise(spUnknown);

	ISTCardReaderPtr reader = device->CardReader;

	IUnknownPtr spUnknownReader = reader;
	CEventHandler* eventHandlerReader = new CEventHandler();
	hr = eventHandlerReader->DispEventAdvise(spUnknownReader);

	device->StartReading();

	//Asynchronous events will hang if the messages aren't pumped, for instance a while(true){sleep(100)} doesn't work here.
	MSG msg;
    while (GetMessage(&msg, 0,0,0)) {
       TranslateMessage(&msg);
       DispatchMessage(&msg);
    }

	eventHandler->DispEventUnadvise(device.GetInterfacePtr());

	CoUninitialize ();   //DeInitialize all COM Components
	return 0;
}

