// Cpp.cpp : STSeries example in C++

#include "stdafx.h"
#include "stdio.h" 
#include "string.h"
#include <msclr\marshal.h>
#include "Cpp.h"

using namespace System; 
using namespace std;
using namespace msclr::interop;

namespace CppExample
{
	extern "C"
	{
		/// <summary>
		/// Gets the first Scriptel STSeries device found.
		/// Reports all devices found to stdout
		/// </summary>
		/// <returns>The first device found</returns>
		ISTSeriesDevice^ STExample::getFirstDevice()
		{
			ISTSeriesDevice^ firstDevice;
			ISTSeriesDevicesManager^ devices = gcnew STSeriesDevicesManager();

			int numOfDevices = devices->GetNumberOfSTSeriesDevices();
			if (numOfDevices == 0)
			{
				Console::WriteLine("No Scriptel STSeries devices were found on the system.");
			}
			else if (numOfDevices == 1)
			{
				Console::WriteLine("The followin Scriptel STSeries device was found on the system:");
			}
			else
			{
				Console::WriteLine("The followin Scriptel STSeries devices were found on the system:");
			}


			for (int devNum = 0; devNum < numOfDevices; devNum++)
			{
				ISTSeriesDevice^ device = devices->GetSTSeriesDevice(devNum);
				if (devNum == 0)
				{
					firstDevice = device;
				}

				Console::WriteLine("{0}: {1}", devNum + 1, device->DeviceName);
			}
			Console::WriteLine();

			return firstDevice;
		}

		/// <summary>
		/// Called when the screen is touched (not starting on a button container).
		/// </summary>
		/// <param name="sender">The sender.</param>
		/// <param name="event">The event.</param>
		void STExample::OnContainerEvent(Object^ sender, STSeriesDevice::RegionSelectedEventArgs^ event)
		{
			// add the point to the signature
			sig->AddPoint(event->SigPoint);

			// write the coordinates to stdout
			Console::Write("Coordinates {0}, {1} pen", event->SigPoint->X, event->SigPoint->Y);
			if (event->SigPoint->SwitchStatus == STSignaturePoint::InputDeviceStatus::PenTipSwitchFingerDown)
			{
				Console::Write("down\n");
			}
			else
			{
				Console::Write("up\n");
			}
		}

		/// <summary>
		/// Called when the touch starts on a button.
		/// </summary>
		/// <param name="sender">The sender.</param>
		/// <param name="event">The event.</param>
		void STExample::OnButtonEvent(Object^ sender, STSeriesDevice::RegionSelectedEventArgs^ event)
		{
			if (event->RegionNumber == 3)	// OK button, clear the signature
			{
				sig = gcnew STSignature;	// forget the old signature
				device->CurrentDisplay->ClearDisplay();
			}
			else if (event->RegionNumber == 4)
			{
				cancelled->Set();	// Cancel pressed, allow RunFirstDevice to proceed from WaitOne
			}
		}

		/// <summary>
		/// Called when a card is swiped.
		/// </summary>
		/// <param name="sender">The sender.</param>
		/// <param name="event">The event.</param>
		void STExample::OnCardSwipe(Object^ sender, STCardReader::CardSwipedEventArgs^ event)
		{
			Console::Write(event->TrackOneContent);
			Console::Write("\n");
		}

		/// <summary>
		/// Runs the first device.
		/// </summary>
		void STExample::RunFirstDevice()
		{
			device = getFirstDevice();

			if (device) {
				Console::WriteLine("Using device #1");
				Console::WriteLine("Tap OK to clear screen");
				Console::WriteLine("Tap Cancel on screen to exit program\n");

				try {
					sig = gcnew STSignature;
					device->Open();

					//Register to recMeive information when a coordinate is received inside a container region
					containerTarget = gcnew STSeriesDevice::ContainerSelectedEventHandler(this, &STExample::OnContainerEvent);
					device->RegisterForContainerSelectedEvent(this, containerTarget);

					buttonTarget = gcnew STSeriesDevice::ButtonSelectedEventHandler(this, &STExample::OnButtonEvent);
					device->RegisterForButtonSelectedEvent(this, buttonTarget);

					device->StartReading();

					cardTarget = gcnew  STCardReader::CardSwipedEventHandler(this, &STExample::OnCardSwipe);
					device->CardReader->RegisterForCardSwipedEvent(this, cardTarget); 

					cancelled->WaitOne();
					Console::WriteLine("\n\nCancell was pressed, exiting program");

					device->StopReading();
					device->Close();
				}
				catch (Exception^ ex)
				{
					Console::WriteLine("\n\nAn Unexpected Exception happened\n{0}\n", ex->Message);
				}
				finally
				{
					device->UnregisterForContainerSelectedEvent(this, containerTarget);
					device->UnregisterForButtonSelectedEvent(this, buttonTarget);
				}
			}
		}

		int _tmain(int argc, _TCHAR* argv[]) {
			Console::WriteLine("STSeries Example in C++");

			// instantiate the class on the stack and run
			STExample example;
			example.RunFirstDevice();
			return 0;
		}
	}
}


