﻿// <copyright file="SignatureMetaData.cs" company="Scriptel Corporation">
//      Copyright 2015 - Scriptel Corporation
// </copyright>
namespace EasyScriptAPI
{
    using System;
    using System.Text;

    /// <summary>
    /// This class represents the metadata present in the preamble of a signature
    /// stream.
    /// </summary>
    public class SignatureMetaData
    {
        /// <summary>
        /// The version of the protocol used to generate this signature.
        /// </summary>
        private string protocolVersion;

        /// <summary>
        /// The model number of the device used to generate this signature.
        /// </summary>
        private string model;

        /// <summary>
        /// The firmware version of the device used to generate this signature.
        /// </summary>
        private string version;

        /// <summary>
        /// Returns a human readable string representation of this object.
        /// </summary>
        /// <returns>Human readable string representation of this object.</returns>
        public override string ToString()
        {
            StringBuilder sb = new StringBuilder();
            string newline = Environment.NewLine;
            sb.Append("Scriptel EasyScript Metadata:").Append(newline);
            sb.Append("   Protocol Version: ").Append(this.protocolVersion).Append(newline);
            sb.Append("       Device Model: ").Append(this.model).Append(newline);
            sb.Append("   Firmware Version: ").Append(this.version).Append(newline);
            return sb.ToString();
        }

        /// <summary>
        /// Property for the protocol version.
        /// </summary>
        public string ProtocolVersion
        {
            get
            {
                return protocolVersion;
            }
            set
            {
                protocolVersion = value;
            }
        }

        /// <summary>
        /// Property for the model.
        /// </summary>
        public string Model
        {
            get
            {
                return model;
            }
            set
            {
                model = value;
            }
        }

        /// <summary>
        /// Property for the version.
        /// </summary>
        public string Version
        {
            get
            {
                return version;
            }
            set
            {
                version = value;
            }
        }
    }
}
