﻿// <copyright file="SignatureInvalidException.cs" company="Scriptel Corporation">
//      Copyright 2014 - Scriptel Corporation
// </copyright>
namespace EasyScriptAPI
{
    using System;

    /// <summary>
    /// This exception is thrown when there is a problem parsing a signature string
    /// </summary>
    public class SignatureInvalidException : Exception
    {
        /// <summary>
        /// The position that the error occurred at during parsing.
        /// </summary>
        private int position = -1;
    
        /// <summary>
        /// Initializes a new instance of the <see cref="SignatureInvalidException"/> class. This
        /// exception is thrown when there is a problem parsing a signature.
        /// </summary>
        /// <param name="msg">Message containing a more detailed description of this error</param>
        /// <param name="pos">Position the error occurred at</param>
        public SignatureInvalidException(string msg, int pos) : base(msg)
        {
            this.position = pos;
        }

        /// <summary>
        /// Gets the position in the string the error occurred
        /// </summary>
        /// <returns>the position in the string the error occurred</returns>
        public int GetPosition()
        {
            return this.position;
        }
    
        /// <summary>
        /// Gets a human readable version of this object.
        /// </summary>
        /// <returns>human readable version of this object.</returns>
        public override string ToString()
        {
            string str = base.ToString();
            str += " (position " + this.position + ")";
            return str;
        }
    }
}
