﻿// <copyright file="STNCardSwipeProtocol.cs" company="Scriptel Corporation">
//      Copyright 2014 - Scriptel Corporation
// </copyright>
namespace EasyScriptAPI
{
    /// <summary>
    /// Initializes a new instance of the <see cref="STNCardSwipeProtocol"/> class. Represents
    /// the STN card swipe protocol.
    /// </summary>
    public class STNCardSwipeProtocol : ICardSwipeProtocol
    {
        /// <summary>
        /// Start stream character.
        /// </summary>
        private char startStream = '!';

        /// <summary>
        /// End stream character.
        /// </summary>
        private char endStream = '\r';

        /// <summary>
        /// Start of stream sentinel.
        /// </summary>
        private string sentinel = "STCARD";

        /// <summary>
        /// Returns the character that denotes the start of a card swipe
        /// </summary>
        /// <returns>character that starts a card swipe</returns>
        public char GetStartStream()
        {
            return this.startStream;
        }

        /// <summary>
        /// Returns the character that denotes the end of a card swipe
        /// </summary>
        /// <returns>character that ends a card swipe</returns>
        public char GetEndStream()
        {
            return this.endStream;
        }

        /// <summary>
        /// Returns the 'sentinel', the string immediately following the card swipe start character
        /// </summary>
        /// <returns>the sentinel string</returns>
        public string GetSentinel()
        {
            return this.sentinel;
        }
    }
}
