﻿// <copyright file="ICardSwipeProtocol.cs" company="Scriptel Corporation">
//      Copyright 2014 - Scriptel Corporation
// </copyright>
namespace EasyScriptAPI
{
    /// <summary>
    /// This interface represents a template for card swipe protocols. In order for
    /// this library to parse magnetic strip data a class implementing this interface
    /// must be created describing the new protocol.
    /// </summary>
    public interface ICardSwipeProtocol
    {
        /// <summary>
        /// Returns the character that denotes the start of a card swipe
        /// </summary>
        /// <returns>character that starts a card swipe</returns>
        char GetStartStream();
        
        /// <summary>
        /// Returns the character that denotes the end of a card swipe
        /// </summary>
        /// <returns>character that ends a card swipe</returns>
        char GetEndStream();
        
        /// <summary>
        /// Returns the 'sentinel', the string immediately following the card swipe start character
        /// </summary>
        /// <returns>the sentinel string</returns>
        string GetSentinel();
    }
}
