<?php
/**
 * This file contains the {@link SignatureMetaData} class.
 * @copyright (c) 2015, Scriptel Corporation.
 */
namespace com\scriptel;

/**
 * This class represents information of the EasyScriptdevice that is included in the signature.
 */
class SignatureMetaData {
    /**
     * The captured protocol version. At present A, B, C, D and E exist.
     * @var string
     */
    private $protocolVersion;
    /**
     * The model of the device that captured the signature.
     * @var string
     */
    private $model;
    /**
     * The currently running version of the firmware on the device that captured the signature.
     * @var string
     */
    private $version;
    /**
     * Constructor, creates a new instance of SignatureMetaData class.
     * @param string $protocolVersion The captured protocol version.
     * @param string $model The model of the device that captured the signature.
     * @param string $version The currently running version of the firmware on the device that captured the signature.
     */
    public function __construct($protocolVersion, $model, $version){
        $this->protocolVersion = $protocolVersion;
        $this->model = $model;
        $this->version = $version;
    }
    /**
     * Gets the captured protocol version.
     * @return string The captured protocol version.
     */
    function getProtocolVersion() {
        return $this->protocolVersion;
    }
    /**
     * Gets the model of the device that captured the signature.
     * @return string The model of the device that captured the signature.
     */
    function getModel() {
        return $this->model;
    }
    /**
     * Gets the currently running version of the firmware on the device that captured the signature.
     * @return string The currently running version of the firmware on the device that captured the signature.
     */
    function getVersion() {
        return $this->version;
    }
    /**
     * Sets the captured protocol version.
     * @param string $protocolVersion
     */
    function setProtocolVersion($protocolVersion) {
        $this->protocolVersion = $protocolVersion;
    }
    /**
     * Sets the model of the device that captured the signature.
     * @param string $model
     */
    function setModel($model) {
        $this->model = $model;
    }
    /**
     * Sets the currently running version of the firmware on the device that captured the signature.
     * @param string $version
     */
    function setVersion($version) {
        $this->version = $version;
    }

}