<?php
/**
 * This file contains the {@link STNCardSwipeProtocol} class.
 * @copyright (c) 2015, Scriptel Corporation.
 */
namespace com\scriptel;

/**
 * This class represents the STN card swipe protocol.
 */
class STNCardSwipeProtocol implements CardSwipeProtocol {
    /**
     * This character indicates the start of the signature.
     * @var string
     */
    private $startStream = "!";
    /**
     * This character indicates the end of the signature.
     * @var string
     */
    private $endStream = "\n";
    /**
     * This string represents the sentinel of the signature.
     * @var string
     */
    private $sentinel = "STCARD";

    /**
     * Returns the end char of the signature.
     * @return string
     */
    public function getEndStream() {
        return $this->endStream;
    }

    /**
     * Returns the sentinel of the signature.
     * @return string
     */
    public function getSentinel() {
        return $this->sentinel;
    }

    /**
     * Returns the start char of the signature.
     * @return string
     */
    public function getStartStream() {
        return $this->startStream;
    }

}
