<?php
/**
 * This file contains the {@link IdentificationCardTrackOne} class.
 * @copyright (c) 2015, Scriptel Corporation.
 */
namespace com\scriptel;

/**
 * This class represents track one of the magnetic strip of an identification
 * card, such as a United States drivers license.
 */
class IdentificationCardTrackOne {
    /**
     * Card-holder State.
     * @var string
     */
    private $state;
    /**
     * card-holder city.
     * @var string
     */
    private $city;
    /**
     * card-holder last name.
     * @var string
     */
    private $lastName;
    /**
     * card-holder first name.
     * @var string
     */
    private $firstName;
    /**
     * card-holder middle name.
     * @var string
     */
    private $middleName;
    /**
     * csrd-holder address.
     * @var string
     */
    private $address;
    /**
     * Vendor-specific discretionary data.
     * @var string
     */
    private $discretionaryData;

    /**
     * This method attempts to parse the first track of data out of a magnetic
     * strip string.
     * @param string $trackData
     * @return IdentificationCardTrackOne
     */
    public static function parse($trackData) {
        $myPattern = ".\%([A-Z]{2})([A-Z\.\-' ]{1,13})\^?([A-Z\.\-' \$]{1,35})\^?([^\?^\^]{1,29})\^?\?.";
        $matches[] = NULL;
        $pattern = '/[\s $-]/';
        preg_match($myPattern, $trackData, $matches);
        if (count($matches) > 0 ) {
            $track = new IdentificationCardTrackOne();
            $track->setState($matches[1]);
            $track->setCity($matches[2]);
            $bits = preg_split($pattern,$matches[3]);
            $track->setLastName($bits[0]);
            if(count($bits)>1) {
                $track->setFirstName($bits[1]);
            }
            if(count($bits)>2) {
                $track->setMiddleName($bits[2]);
            }

            $track->setAddress($matches[4]);
            return $track;
        }
        return NULL;
    }
    /**
     * Returns this object as a human readable string.
     * @return string
     */
    public function toString() {
        $strCardData = "";
        $strCardData .= "Identification Card - Track One: \n";
        $strCardData .= "             State: " . $this->getState() . "\n";
        $strCardData .= "              City: " . $this->getCity() . "\n";
        $strCardData .= "        First Name: " . $this->getFirstName() . "\n";
        $strCardData .= "       Middle Name: " . $this->getMiddleName() . "\n";
        $strCardData .= "         Last Name: " . $this->getLastName() . "\n";
        $strCardData .= "           Address: " . $this->getAddress() . "\n";
        $strCardData .= "Discretionary Data: " . $this->getDiscretionaryData() . "\n";
        return $strCardData;
    }
    /**
     * Gets the card-holders state.
     * @return string
     */
    function getState() {
        return $this->state;
    }
    /**
     * Gets the card-holders city.
     * @return string
     */
    function getCity() {
        return $this->city;
    }
    /**
     * Gets the card-holders last name.
     * @return string
     */
    function getLastName() {
        return $this->lastName;
    }
    /**
     * Gets the card-holders first name.
     * @return string
     */
    function getFirstName() {
        return $this->firstName;
    }
    /**
     * Gets the card-holders middle name.
     * @return string
     */
    function getMiddleName() {
        return $this->middleName;
    }
    /**
     * Gets the card-holders address.
     * @return string
     */
    function getAddress() {
        return $this->address;
    }
    /**
     * Gets the vendor-specific discretionary data.
     * @return string
     */
    function getDiscretionaryData() {
        return $this->discretionaryData;
    }
    /**
     * Sets the card-holder state.
     * @param string $state
     */
    function setState($state) {
        $this->state = $state;
    }
    /**
     * Sets the card-holder city.
     * @param string $city
     */
    function setCity($city) {
        $this->city = $city;
    }
    /**
     * Sets the card-holder last name.
     * @param string $lastName
     */
    function setLastName($lastName) {
        $this->lastName = $lastName;
    }
    /**
     * Sets the card-holder first name.
     * @param string $firstName
     */
    function setFirstName($firstName) {
        $this->firstName = $firstName;
    }
    /**
     * Sets the card-holder middle name.
     * @param string $middleName
     */
    function setMiddleName($middleName) {
        $this->middleName = $middleName;
    }
    /**
     * Sets the card-holder address.
     * @param string $address
     */
    function setAddress($address) {
        $this->address = $address;
    }
    /**
     * Sets the Vendor-specific discretionary data.
     * @param string $discretionaryData
     */
    function setDiscretionaryData($discretionaryData) {
        $this->discretionaryData = $discretionaryData;
    }


}
