<?php
/**
 * This file contains the {@link EasyScriptStreamingState} class.
 * @copyright (c) 2015, Scriptel Corporation.
 */
namespace com\scriptel;

/**
 * This enumeration is used to determine which state the EasyScript decoder is
 * currently in.
 */
abstract class SignatureStateEnum {
    /**
     * Constructor, creates a new instance of this class.
     * @param string state The signature state.
     */
    final public function __construct($state) {
        $myClass = new \ReflectionClass($this);
        if (!in_array($state, $myClass->getConstants())) {
            throw InvalidArgumentException();
        }
        $this->state = $state;
    }

    /**
     * This method gets the underlying constant behind this type.
     * @returns string Signature state
     */
    final public function getState() {
        return $this->state;
    }
}
/**
 * This class contains the various constants used by {@link SignatureStateEnum}.
 */
class EasyScriptStreamingState extends SignatureStateEnum {
    /**
     *
     */
    const UNKNOWN = 'UNKNOWN';
    /**
     * We're expecting a card sentinel to be next.
     */
    const CARD_SENTINEL = 'CARD_SENTINEL';
    /**
     * We're expecting card data.
     */
    const CARD_DATA = 'CARD_DATA';
    /**
     * We're expecting a signature sentinel to be next.
     */
    const SIGNATURE_SENTINEL = 'SIGNATURE_SENTINEL';
    /**
     * We're expecting a protocol version to be next.
     */
    const PROTOCOL_VERSION = 'PROTOCOL_VERSION';
    /**
     * We're expecting a model number to be next.
     */
    const MODEL = 'MODEL';
    /**
     * We're expecting a firmware version to be next.
     */
    const FIRMWARE_VERSION = 'FIRMWARE_VERSION';
    /**
     * We're expecting a compressed signature to be next.
     */
    const SIGNATURE_COMPRESSED = 'SIGNATURE_COMPRESSED';
    /**
     * We're expecting an uncompressed signature to be next.
     */
    const SIGNATURE_UNCOMPRESSED = 'SIGNATURE_UNCOMPRESSED';
    /**
     * A card swipe is currently interrupting an uncompressed stream.
     */
    const CARD_INTERRUPTING_UNCOMPRESSED = 'CARD_INTERRUPTING_UNCOMPRESSED';
    /**
     * A card swipe is currently interrupting a compressed stream.
     */
    const CARD_INTERRUPTING_COMPRESSED = 'CARD_INTERRUPTING_COMPRESSED';
}
