<?php
/**
 * This file contains the {@link EasyScriptDecoder} class.
 * @copyright (c) 2015, Scriptel Corporation.
 */
namespace com\scriptel;

/**
 * This interface is used to define an EasyScript decoder. The decoders are
 * responsible for decoding any data after the preamble.
 */
interface EasyScriptDecoder {
   /**
    * This receives the signature or card data and calls parseSignature method using one character
    * at a time.
    * @param string $str The signature or card data.
    */
    public function parseSignature($str);
    /**
     * This will be called by EasyScript when a character is received for this
     * decoder.
     * @param string $str
     */
    public function parse($str);
}
