<?php
/**
 * This file contains the {@link BoundingBox} class.
 * @copyright (c) 2015, Scriptel Corporation.
 */
namespace com\scriptel;

/**
 * This class represents a bounding box that contains a signature.
 */
class BoundingBox {
    /**
     * This contains the value of the left-most coordinate.
     * @var float
     */
    private $x1 = 1000000;
    /**
     * This contains the value of the right-most coordinate.
     * @var float
     */
    private $x2 = -1;
    /**
     * This contains the value of the top-most coordinate.
     * @var float
     */
    private $y1 = 1000000;
    /**
     * This contains the value of the bottom-most coordinate.
     * @var float
     */
    private $y2 = -1;
    /**
     * This contains the width of the bounding box.
     * @var float
     */
    private $width;
    /**
     * This contains the height of the bounding box.
     * @var float
     */
    private $height;
    /**
     * Gets the value of the left-most coordinate.
     * @return float
     */
    public function getX1() {
        return $this->x1;
    }
    /**
     * Sets the value of the left-most coordinate.
     * @param float $x1
     */
    public function setX1($x1) {
        $this->x1 = $x1;
    }
    /**
     * Gets the value of the right-most coordinate.
     * @return float
     */
    public function getX2() {
        return $this->x2;
    }
    /**
     * Sets the value of the right-most coordinate.
     * @param float $x2
     */
    public function setX2($x2) {
        $this->x2 = $x2;
    }
    /**
     * Gets the value of the top-most coordinate.
     * @return float
     */
    public function getY1() {
        return $this->y1;
    }
    /**
     * Sets the value of the top-most coordinate.
     * @param float $y1
     */
    public function setY1($y1) {
        $this->y1 = $y1;
    }
    /**
     * Gets the value of the bottom-most coordinate.
     * @return float
     */
    public function getY2() {
        return $this->y2;
    }
    /**
     * Sets the value of the bottom-most coordinate.
     * @param float $y2
     */
    public function setY2($y2) {
        $this->y2 = $y2;
    }
    /**
     * Gets the width of the bounding box.
     * @return float
     */
    public function getWidth() {
        return $this->width;
    }
    /**
     * Sets the width of the bounding box.
     * @param float $width
     */
    public function setWidth($width) {
        $this->width = $width;
    }
    /**
     * Gets the height of the bounding box.
     * @return float
     */
    public function getHeight() {
        return $this->height;
    }
    /**
     * Sets the height of the bounding box.
     * @param float $height
     */
    public function setHeight($height) {
        $this->height = $height;
    }
}