<?PHP
/**
 * This example contains a simple web page that will prompt a user to sign using
 * a Scriptel ScripTouch keyboard wedge and hit "submit". Upon hitting submit
 * the signature (or card swipe) will be rendered and sent back to the client.
 * @author Scriptel Corporation
 * @copyright 2013 - Scriptel Corporation
 */
require_once("../scriptel-easyscript.phar");

if(isset($_POST['signature'])) {
    //The user has submitted a signature to us.
    $eScript = new \com\scriptel\EasyScript();
    try {
        //Try to parse what they sent.
        $result = $eScript->parse($_POST['signature']);
        
        if($result instanceof \com\scriptel\Signature) {
            //If the result is a signature, lets send it back as an image.
            header("Content-type: image/png");
            $result->getImagePng(3,1,array(0,0,0xFF,0),array(0,0,0,127));
        } else if($result instanceof \com\scriptel\CardSwipe) {
            //If the result is a card swipe lets send it back to the client.
            header("Content-type: text/plain");
            print_r($result);
        }
    } catch(Exception $e) {
        //Something bad happened while parsing.
        header("Content-type: text/plain");
        echo("There was a problem parsing the signature/card string: ".$e->getMessage());
    }
} else {
    //The user didn't submit anything, lets give them the example form.
?>
<!DOCTYPE html>
<html>
    <head>
        <title>Scriptel ScripTouch EasyScript PHP Example</title>
    </head>
    <body>
        <form action="" method="post">
            Please place the EasyScript string in the box below: <br />
            <textarea name="signature" cols="100" rows="10"></textarea><br />
            <input type="submit" value="Submit" />
        </form>
    </body>
</html>
<?PHP
}
?>
