/*
 * Copyright 2013 - Scriptel Corporation
 */
package com.scriptel.easyscript.cardswipeprotocols;
import com.scriptel.easyscript.CardSwipeProtocol;

/**
 * This class represents the STN card swipe protocol.
 */
public class STNCardSwipeProtocol implements CardSwipeProtocol {
    private static final char START_STREAM = '!';
    private static final char END_STREAM = '\r';
    private static final String SENTINEL = "STCARD";
    
    @Override
    public char getStartStream() {
        return START_STREAM;
    }

    @Override
    public char getEndStream() {
        return END_STREAM;
    }

    @Override
    public String getSentinel() {
        return SENTINEL;
    }
    
}
