/*
 * Copyright 2013 - Scriptel Corporation
 */
package com.scriptel.easyscript;

/**
 * This exception is thrown when there is a problem parsing a signature string.
 */
public class SignatureInvalidException extends Exception {
    /**
     * The position the error occurred at in parsing.
     */
    private final int position;
    
    /**
     * Constructor, creates a new exception of this type.
     * @param msg Message containing a more detailed description of this error.
     * @param pos Position the error occurred at.
     */
    public SignatureInvalidException(String msg, int pos) {
        super(msg);
        this.position = pos;
    }

    /**
     * Gets the position in the string the error occurred.
     * @return the position the error occurred
     */
    public int getPosition() {
        return position;
    }
    
    /**
     * Gets a human readable version of this object.
     * @return Human readable version of this object.
     */
    @Override
    public String toString() {
        String str = super.toString();
        str += " (position "+position+")";
        return str;
    }
}
