/*
 * Copyright 2015 - Scriptel Corporation
 */
package com.scriptel.easyscript;

/**
 * This enumeration is used to determine which state the EasyScript decoder is
 * currently in.
 */
public enum EasyScriptStreamingState {
    /**
     * We're expecting a card sentinel to be next.
     */
    CARD_SENTINEL,
    /**
     * We're expecting card data.
     */
    CARD_DATA,
    /**
     * We're expecting a signature sentinel to be next.
     */
    SIGNATURE_SENTINEL,
    /**
     * We're expecting a protocol version to be next.
     */
    PROTOCOL_VERSION,
    /**
     * We're expecting a model number to be next.
     */
    MODEL,
    /**
     * We're expecting a firmware version to be next.
     */
    FIRMWARE_VERSION,
    /**
     * We're expecting a compressed signature to be next.
     */
    SIGNATURE_COMPRESSED,
    /**
     * We're expecting an uncompressed signature to be next.
     */
    SIGNATURE_UNCOMPRESSED,
    /**
     * Unknown state.
     */
    UNKNOWN,
    /**
     * A card swipe is currently interrupting an uncompressed stream.
     */
    CARD_INTERRUPTING_UNCOMPRESSED,
    /**
     * A card swipe is currently interrupting a compressed stream.
     */
    CARD_INTERRUPTING_COMPRESSED
}
