/*
 * Copyright 2015 - Scriptel Corporation
 */
package com.scriptel.easyscript;

/**
 * This interface is used to define an EasyScript decoder. The decoders are
 * responsible for decoding any data after the preamble.
 */
public interface EasyScriptDecoder {
    /**
     * This will be called by EasyScript when a character is received for this
     * decoder.
     * @param ch Next character in the stream.
     * @throws SignatureInvalidException Should be thrown by the caller in the
     * event a problem is detected.
     */
    void parseSignature(char ch) throws SignatureInvalidException;
}
