/*
 * Copyright 2013 - Scriptel Corporation
 */
package com.scriptel.easyscript;

/**
 * This class represents a successful magnetic card swipe from a ScripTouch
 * EasyScript device with a magnetic card strip reader.
 */
public class CardSwipe {
    /**
     * The protocol version being used to decode the string.
     */
    private String protocolVersion;
    /**
     * The raw card data.
     */
    private String cardData;
    /**
     * If the card is a recognizable financial card, this will contain parsed
     * financial card data.
     */
    private FinancialCard financialCard;
    /**
     * If the card is a recognizable identification card this will contain
     * parsed identification data.
     */
    private IdentificationCard identificationCard;

    /**
     * This method returns a human-readable representation of this class.
     * @return Human readable string describing contents of this object.
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        String ln = System.getProperty("line.separator");
        sb.append("Scriptel EasyScript Card Swipe").append(ln);
        sb.append("Protocol Version: ").append(protocolVersion).append(ln);
        sb.append("       Card Data: ").append(cardData).append(ln);
        if(financialCard!=null) {
            sb.append(financialCard);
        }
        if(identificationCard!=null) {
            sb.append(identificationCard);
        }
        
        return sb.toString();
    }
    
    /**
     * Gets the protocol version of this swipe.
     * @return the protocolVersion
     */
    public String getProtocolVersion() {
        return protocolVersion;
    }

    /**
     * Sets the protocol version of this swipe.
     * @param protocolVersion the protocolVersion to set
     */
    protected void setProtocolVersion(String protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    /**
     * Gets the raw card swipe data.
     * @return the cardData
     */
    public String getCardData() {
        return cardData;
    }

    /**
     * Sets the raw card swipe data.
     * @param cardData Raw card swipe data.
     */
    protected void setCardData(String cardData) {
        this.cardData = cardData;
    }

    /**
     * Gets parsed financial card data, null if not set.
     * @return Parsed financial card data.
     */
    public FinancialCard getFinancialCard() {
        return financialCard;
    }

    /**
     * Sets parsed financial card data.
     * @param financialCard Parsed financial card data.
     */
    protected void setFinancialCard(FinancialCard financialCard) {
        this.financialCard = financialCard;
    }

    /**
     * Gets parsed identification card data.
     * @return Parsed identification card data.
     */
    public IdentificationCard getIdentificationCard() {
        return identificationCard;
    }

    /**
     * Sets parsed identification card data.
     * @param identificationCard Parsed identification card data.
     */
    protected void setIdentificationCard(IdentificationCard identificationCard) {
        this.identificationCard = identificationCard;
    }
}
