﻿// <copyright file="IEasyScriptEventListener.cs" company="Scriptel Corporation">
//      Copyright 2015 - Scriptel Corporation
// </copyright>
namespace EasyScriptAPI
{
    /// <summary>
    /// This interface defines a listener interested in signature events generated
    /// by the EasyScript library.
    /// </summary>
    public interface IEasyScriptEventListener
    {
        /// <summary>
        /// This event receives a parsed coordinate from the signature stream.
        /// </summary>
        /// <param name="coordinate">Coordinate read from signature stream.</param>
        void ReceiveCoordinate(Coordinate coordinate);

        /// <summary>
        /// This event indicates that a new stroke has begun.
        /// </summary>
        void NewStroke();

        /// <summary>
        /// This event indiciates that a signature has been cancelled. 
        /// </summary>
        void Cancel();

        /// <summary>
        /// This event indiciates that a signature has been completed successfully.
        /// </summary>
        void EndOfSignature();

        /// <summary>
        /// This event indiciates that signature metadata has been successfully
        /// received.
        /// </summary>
        /// <param name="metadata">Metadata from signature stream.</param>
        void SignatureMetaData(SignatureMetaData metadata);

        /// <summary>
        /// This event indiciates that a magnetic card was swiped and parsed.
        /// </summary>
        /// <param name="swipe">Card information</param>
        void CardSwipe(CardSwipe swipe);
    }
}
