﻿// <copyright file="CardSwipeInvalidException.cs" company="Scriptel Corporation">
//      Copyright 2014 - Scriptel Corporation
// </copyright>
namespace EasyScriptAPI
{
    using System;

    /// <summary>
    /// This exception is thrown when there is a problem parsing a card swipe string.
    /// </summary>
    public class CardSwipeInvalidException : Exception
    {
        /// <summary>
        /// The position the error occurred at in parsing.
        /// </summary>
        private int position = -1;

        /// <summary>
        /// Initializes a new instance of the <see cref="CardSwipeInvalidException"/> class.
        /// </summary>
        /// <param name="msg">The error message</param>
        /// <param name="pos">Position in the array where the error occurred.</param>
        public CardSwipeInvalidException(string msg, int pos) :
            base(msg)
        {
            this.position = pos;
        }

        /// <summary>
        /// Gets the position in the array where this exception occurred
        /// </summary>
        public int Position
        {
            get
            {
                return this.position;
            }
        }

        /// <summary>
        /// Gets a human readable version of this object.
        /// </summary>
        /// <returns>Human readable version of this object.</returns>
        public override string ToString()
        {
            string str = base.ToString();
            str += " (position " + this.position + ")";
            return str;
        }
    }
}
