/*******************************************************************************
 * example.c - Copyright 2014 - Scriptel Corporation
 * ----
 * This file demonstrates a very simple example of how to use the platform
 * independant C library for Scriptel ScripTouch keyboard products.
 ******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "scriptel-easyscript.h"

#ifdef _MSC_VER		// Windows
	#include <conio.h>	
	#define GETCH() _getch()
#else				// Linux
	#define GETCH() getch()

	#include <termios.h>
	#include <stdio.h>

	static struct termios old, new;

	/* Initialize new terminal i/o settings */
	void initTermios(int echo)
	{
		tcgetattr(0, &old); /* grab old terminal i/o settings */
		new = old; /* make new settings same as old settings */
		new.c_lflag &= ~ICANON; /* disable buffered i/o */
		new.c_lflag = (echo) ? (new.c_lflag | ECHO) : (new.c_lflag & ~ECHO); /* set echo mode */
		tcsetattr(0, TCSANOW, &new); /* use these new terminal i/o settings now */
	}

	/* Restore old terminal i/o settings */
	void resetTermios(void)
	{
		tcsetattr(0, TCSANOW, &old);
	}

	/* Read 1 character - echo defines echo mode */
	char getch_(int echo)
	{
		char ch;
		initTermios(echo);
		ch = getchar();
		resetTermios();
		return ch;
	}

	/* Read 1 character without echo */
	char getch(void)
	{
		char c = getch_(0);
		if (c == '\n') {
			c = '\r';
		}
		return c;
	}

#endif

static int done;

void listener(streaming_event_data *sd) {
	static int coordinate_number = 0;
	static int stroke_number = 0;
	static int signature_number = 0;

	switch (sd->type) {
	case CBT_METADATA:
		signature_number++;
		printf("\nSignature #%d:\n", signature_number);
		printf("    Signature pad model is %s, version %s, protocol %s\n", sd->meta_data.model, sd->meta_data.version, sd->meta_data.protocol_version);
		break;
	case CBT_COORDINATE:
		coordinate_number++;
		printf("    Coordinate #%05d: x=%06.2f, y=%05.2f\n", coordinate_number, sd->coordinate.x, sd->coordinate.y);
		break;
	case CBT_NEWSTROKE:
		stroke_number++;
		coordinate_number = 0;
		printf("    New Stroke #%d\n", stroke_number);
		break;
	case CBT_END_OF_SIGNATURE:
		stroke_number = 0;
		coordinate_number = 0;
		printf("End of signature\n");
		break;
	case CBT_CANCEL:
		stroke_number = 0;
		coordinate_number = 0;
		done = 1;
		printf("You touched CANCEL. Goodbye.\n");
		break;
	case CBT_CARD_DATA:
		scriptel_print_cardswipe(&sd->card_swipe);
		scriptel_free_cardswipe(&sd->card_swipe);
		break;
	}
}

int main() {
	printf("This is an example of processing streaming EasyScript data in C.\n");
	printf("This simple example only works on operating systems\nsetup for US/English keyboards.\n\n");

	printf("Sign and touch OK\n");
	printf("To exit, touch CANCEL\n\n");

	scriptel_add_event_listener(listener);

	done = 0;
	while (!done) {
		scriptel_keyboard_parse_char(&STN_SIGNATURE_PROTOCOL, GETCH());
	}

	scriptel_remove_event_listener(listener);
	exit(0);
}
