<?php
/**
 * This file contains the {@link CardSwipeProtocol} class.
 * @copyright (c) 2015, Scriptel Corporation.
 */
namespace com\scriptel;

/**
 * This interface represents a template for card swipe protocols. In order for
 * this library to parse magnetic strip data a class implementing this interface
 * must be created describing the new protocol.
 */
interface CardSwipeProtocol {
    /**
     * This method should return the character that denotes the start of a new
     * signature.
     * @return string That starts a stream.
     */
    function getStartStream();
    /**
     * This method should return the character that denotes the end of a stream.
     * @return string That ends a stream.
     */
    function getEndStream();
    /**
     * This method should return the "sentinel" for the stream, the set of
     * characters immediately following the start character.
     * @return string The stream's sentinel.
     */
    function getSentinel();
}
