<?php
/**
 * This file contains the {@link CardSwipe} class.
 * @copyright (c) 2015, Scriptel Corporation.
 */
namespace com\scriptel;

/**
 * This class represrnts a successful magnetic card swipe form a ScripTouch EasyScript device
 * with a magnetic card strip reader.
 */
class CardSwipe {
    /**
     * The protocol version being used to decode the string.
     * @var string
     */
    private $protocolVersion;
    /**
     * The raw card data.
     * @var string
     */
    private $cardData;
    /**
     * If the card is a recognizable financial card, this will contain parsed
     * financial card data.
     * @var FinancialCard
     */
    private $financialCard;
    /**
     * If the card is a recognizable identification card this will contain
     * parsed identification data.
     * @var IdentificationCard
     */
    private $identificationCard;

    /**
     * Returns this object as a human readable string.
     * @return string
     */
    public function toString(){
        $strCardData = "";
        $strCardData .= "Scriptel EasyScript Card Swipe \n";
        $strCardData .= "Protocol Version: " . $this->getProtocolVersion() . "\n";
        $strCardData .= "       Card Data: " . $this->getCardData() . "\n";
        if ($this->getFinancialCard() != NULL){
            $strCardData .= $this->getFinancialCard()->toString();
        }
        if ($this->getIdentificationCard() != NULL){
            $strCardData .= $this->getIdentificationCard()->toString();
        }
        return $strCardData;
    }
    /**
     * Gets the protocol version of this swipe.
     * @return string
     */
    function getProtocolVersion() {
        return $this->protocolVersion;
    }
    /**
     * Gets the raw card swipe data.
     * @return string
     */
    function getCardData() {
        return $this->cardData;
    }
    /**
     * Gets parsed financial card data, null if not set.
     * @return FinancialCard.
     */
    function getFinancialCard() {
        return $this->financialCard;
    }
    /**
     * Gets parsed identification card data.
     * @return IdentificationCard.
     */
    function getIdentificationCard() {
        return $this->identificationCard;
    }
    /**
     * Sets the protocol version of this swipe.
     * @param string $protocolVersion
     */
    function setProtocolVersion($protocolVersion) {
        $this->protocolVersion = $protocolVersion;
    }
    /**
     * Sets the raw card swipe data.
     * @param string $cardData
     */
    function setCardData($cardData) {
        $this->cardData = $cardData;
    }
    /**
     * Sets parsed financial card data, null if not set.
     * @param FinancialCard $financialCard
     */
    function setFinancialCard($financialCard) {
        $this->financialCard = $financialCard;
    }
    /**
     * Sets parsed identification card data.
     * @param IdentificationCard $identificationCard
     */
    function setIdentificationCard($identificationCard) {
        $this->identificationCard = $identificationCard;
    }
}
