<?php
/**
 * This file contains the {@link BinaryTreeReader} class.
 * @copyright (c) 2015, Scriptel Corporation.
 */
namespace com\scriptel;

/**
 * This class builds the compression binary tree
 */
class BinaryTreeReader {
    /**
     * Our current location in the binary tree.
     * @var integer
     */
    private $location = 0;
    /**
     * The head node in the binary tree.
     * @var BinaryTree.
     */
    private $head = NULL;
    /**
     * The compression table used to decompress signatures.
     */
    const TABLE = "001100000010000001110110100000000101110000000000101000001000000000100000000010001000000011000100000001000100100000001110100100000010101100100011100000001011101000000100101000000000010010010000001001110000000010010000000001010100000000100010100000010000000111101000000000011000100000001010010000001111000010000001010101000000010111100000001001101000000000111010000000011101000000001100000000100000011001110000001101110100000010001101000000111010100000011001000100000001101110000000111001000000001010010000001111010100001100000001000000100110010000001001110010001100000000001001111000000011010010000001011110000000101000100000001010000000000100101100000010000001011010010000000000000010000001001010100000010111010000001100011000000010000001000000001101100000001011001000000000101100000001001000001000000000110010000000101011000000101000010000000010001000000001111000001000000110110000010011000000001001101000000001010101000000101100100000001100110000000110001000000000101001000000010110100000000101011100000010110110000000000101111100000011010000000000110000000000011011000000000011000010000001101101000000011001010000001010110000000000110001100000010110000000000110101000000011001110000000011001000000001010011000000011010110000001011100000000100010000000001000000100010110111000000010000000000011000000111110000100000000100101000000011111010000001010011000000101111100001000000000001000000111001010000001101001000000111000100000010110001000000111111100000010000100010000001101011000000100000100000001101000100000011000010000001001001000000011001";
    /**
     * This method finds that decimal value for some number of bits in the table starting at location.
     * @param integer $bitDepth Number of bits to read.
     * @return integer The decimal value of the bits read.
     */
    public function readTableValue($bitDepth) {
        $ch = NULL;
        $v = 0;
        for ($i = 0; $i < $bitDepth; $i++){
            $ch = substr(self::TABLE,$this->location++, 1);
            $v = ($v * 2) + ($ch === '0' ? 0 : 1);
        }
        return $v;
    }

    /**
     * This method sets values to the leafs in the compression binary tree.
     * @param integer $bitDepth
     * @return BinaryTree The compressed binary tree.
     */
    public function writeTree($bitDepth) {
        $node = new BinaryTree();
        $type = $this->readTableValue(1);
        if ($type === 0){  // node found
            $node->setLeft($this->writeTree($bitDepth));
            $node->setRight($this->writeTree($bitDepth));
        } else {  // leaf found
            $node->setValue($this->readTableValue($bitDepth));
        }
       return $node;
    }
    /**
     * Constructor, creates a new instance of BinaryTreeReader class.
     */
    public function __construct() {
        if ($this->head == NULL){
            $bitDepth = $this->readTableValue(6);
            $this->head = $this->writeTree($bitDepth);
        }
    }
    /**
     * This method gets the head of the binary tree.
     * @return BinaryTree.
     */
    public function getTree() {
        return $this->head;
    }
}
