/*
 * Copyright 2015 - Scriptel Corporation
 */
package com.scriptel.easyscript;

/**
 * This interface defines a listener capable of receiving streaming EasyScript
 * events.
 */
public interface EasyScriptEventListener {
    /**
     * This method will be called when a coordinate is parsed from the signature
     * stream.
     * @param coordinate Most recent coordinate from the signature stream.
     */
    public void receiveCoordinate(Coordinate coordinate);
    /**
     * This method will be called when a new stroke is detected in the signature
     * stream.
     */
    public void newStroke();
    /**
     * This method will be called when the signature is cancelled by pressing
     * the "Cancel" button on the signature pad.
     */
    public void cancel();
    /**
     * This method will be called when the signature is accepted by pressing the
     * "OK" or "Accept" button on the signature pad.
     */
    public void endOfSignature();
    /**
     * This method is called when the signature metadata is captured from the
     * signature stream.
     * @param metaData Metadata regarding the current signature.
     */
    public void signatureMetaData(SignatureMetaData metaData);
    /**
     * This method is called when a card swipe is detected in the signature
     * stream.
     * @param swipe Card Swipe
     */
    public void cardSwipe(CardSwipe swipe);
}
