/*
 * Copyright 2013 - Scriptel Corporation
 */
package com.scriptel.easyscript;

/**
 * This class represents a two dimensional coordinate on a digitizer.
 */
public class Coordinate {
    private double x;
    private double y;
    
    /**
     * Constructor, creates a new instance of this class.
     * @param x Horizontal coordinate between 0 and 1.
     * @param y Vertical coordinate between 0 and 1.
     */
    public Coordinate(double x, double y) {
        this.x = x;
        this.y = y;
    }

    /**
     * The horizontal coordinate between 0 and 1.
     * @return Horizontal Coordinate.
     */
    public double getX() {
        return x;
    }

    /**
     * The vertical coordinate between 0 and 1.
     * @return Vertical Coordinate.
     */
    public double getY() {
        return y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }
    
    /**
     * Returns this object as a human readable string.
     * @return String containing human readable string.
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{x:").append(x).append(", y:").append(y).append('}');
        return sb.toString();
    }
}
