/*
 * Copyright 2013 - Scriptel Corporation
 */
package com.scriptel.easyscript;

/**
 * This interface represents a template for card swipe protocols. In order for
 * this library to parse magnetic strip data a class implementing this interface
 * must be created describing the new protocol.
 */
public interface CardSwipeProtocol {
    /**
     * This method should return the character that denotes the start of a new
     * signature.
     * @return Character that starts a stream.
     */
    char getStartStream();
    /**
     * This method should return the character that denotes the end of a stream.
     * @return Character that ends a stream.
     */
    char getEndStream();
    /**
     * This method should return the "sentinel" for the stream, the set of
     * characters immediately following the start character.
     * @return The streams sentinel.
     */
    String getSentinel();
}
