/*
 * Copyright 2015 - Scriptel Corporation
 */
package com.scriptel.easyscript;

/**
 * This class represents a single node in a binary tree.
 */
public class BinaryTree {
    /**
     * If this node is a leaf, this contains the value of the leaf.
     */
    private int value;
    /**
     * If this node is a branch this contains the left node.
     */
    private BinaryTree left;
    /**
     * If this node is a branch this contains the right node.
     */
    private BinaryTree right;
    
    /**
     * Constructor, creates a new instance of BinaryTree class.
     */
    public BinaryTree() {
        this.value = 0;
        this.left = null;
        this.right = null;
    }
    
    /**
     * This method returns the value of a leaf.
     * @return The value of the node.
     */
    public int getValue() {
        return value;
    }

    /**
     * This method sets a value of this leaf.
     * @param value Value to set.
     */
    public void setValue(int value) {
        this.value = value;
    }

    /**
     * This method returns the left child node (binary tree) of the current node
     * @return The left node (binary tree) of the current node
     */
    public BinaryTree getLeft() {
        return left;
    }

    /**
     * This method sets the left child node (binary tree) of the current node
     * @param left The left node (binary tree) to set to the current node
     */
    public void setLeft(BinaryTree left) {
        this.left = left;
    }

    /**
     * This method returns the right child node (binary tree) of the current node
     * @return The right node (binary tree) of the current node
     */
    public BinaryTree getRight() {
        return right;
    }

    /**
     * This method sets the right child node (binary tree) of the current node
     * @param right The right node (binary tree) to set to the current node
     */
    public void setRight(BinaryTree right) {
        this.right = right;
    }

}

