﻿// <copyright file="SignatureBounds.cs" company="Scriptel Corporation">
//      Copyright 2014 - Scriptel Corporation
// </copyright>
namespace EasyScriptAPI
{
    /// <summary>
    /// This class represents the minimum bounding box required to hold a given
    /// signature.
    /// </summary>
    public class SignatureBounds
    {
        /// <summary>
        /// The left-most coordinate in the box.
        /// </summary>
        public double X1 { get; set; }
        /// <summary>
        /// The right-most coordinate in the box.
        /// </summary>
        public double X2 { get; set; }
        /// <summary>
        /// The upper-most coordinate in the box.
        /// </summary>
        public double Y1 { get; set; }
        /// <summary>
        /// The lower-most coordinate in the box.
        /// </summary>
        public double Y2 { get; set; }
        /// <summary>
        /// The width of the bounding box.
        /// </summary>
        public double Width { get; set; }
        /// <summary>
        /// The height of the bounding box.
        /// </summary>
        public double Height { get; set; }
    }
}
