﻿// <copyright file="STNSignatureProtocol.cs" company="Scriptel Corporation">
//      Copyright 2014 - Scriptel Corporation
// </copyright>
namespace EasyScriptAPI
{
    /// <summary>
    /// This class implements the STN Protocol for the Scriptel ScripTouch EasyScript product.
    /// </summary>
    public class STNSignatureProtocol : ISignatureProtocol
    {
        /// <summary>
        /// Start of stream character.
        /// </summary>
        private static readonly char startStream = '~';

        /// <summary>
        /// End of stream character.
        /// </summary>
        private static readonly char endStream = '`';

        /// <summary>
        /// Cancel stream character.
        /// </summary>
        private static readonly char cancelStream = '/';

        /// <summary>
        /// Pen up character.
        /// </summary>
        private static readonly char penUp = ' ';

        /// <summary>
        /// Start sentinel.
        /// </summary>
        private static readonly string sentinel = "STSIGN";

        /// <summary>
        /// Width of the display of the device.
        /// </summary>
        private static readonly int width = 240;

        /// <summary>
        /// Height of the display of the device.
        /// </summary>
        private static readonly int height = 64;

        /// <summary>
        /// Decoding table for horizontal values.
        /// </summary>
        private byte[][] xValues;

        /// <summary>
        /// Decoding table for vertical values.
        /// </summary>
        private byte[][] yValues;

        /// <summary>
        /// Initializes a new instance of the <see cref="STNSignatureProtocol"/> class.
        /// </summary>
        public STNSignatureProtocol()
        {
            this.xValues = new byte[2][]
            {
                new byte[] { 0x41, 0x43, 0x45, 0x47, 0x49, 0x4b, 0x4d, 0x4f, 0x51, 0x53, 0x55, 0x57, 0x59, 0x21, 0x23, 0x25, 0x26, 0x28, 0x2b, 0x7d, 0x22, 0x3c },
                new byte[] { 0x42, 0x44, 0x46, 0x48, 0x4a, 0x4c, 0x4e, 0x50, 0x52, 0x54, 0x56, 0x58, 0x5a, 0x40, 0x24, 0x5e, 0x2a, 0x29, 0x5f, 0x7b, 0x7c, 0x3a, 0x3e } 
            };

            this.yValues = new byte[2][]
            {
                new byte[] { 0x61, 0x63, 0x65, 0x67, 0x69, 0x6b, 0x6d, 0x6f, 0x71, 0x73, 0x75, 0x77, 0x79, 0x31, 0x33, 0x35, 0x37, 0x39, 0x3d, 0x5d, 0x27, 0x2c },
                new byte[] { 0x62, 0x64, 0x66, 0x68, 0x6a, 0x6c, 0x6e, 0x70, 0x72, 0x74, 0x76, 0x78, 0x7a, 0x32, 0x34, 0x36, 0x38, 0x30, 0x2d, 0x5b, 0x5c, 0x3b, 0x2e }
            };
        }

        /// <summary>
        ///  This method returns the character that denotes the start of a new 
        ///  signature.
        /// </summary>
        /// <returns>Character that starts a stream</returns>
        public char GetStartStream()
        {
            return startStream;
        }

        /// <summary>
        ///  This method returns the character that denotes the end of a stream 
        /// </summary>
        /// <returns>Character that ends a stream</returns>
        public char GetEndStream()
        {
            return endStream;
        }

        /// <summary>
        ///  This method returns the character that denotes  a stream has been cancelled.
        /// </summary>
        /// <returns>Character that cancels a stream</returns>
        public char GetCancelStream()
        {
            return cancelStream;
        }

        /// <summary>
        ///  This method returns the character that denotes a "pen up" event,
        ///  or the start of a new stroke.
        /// </summary>
        /// <returns>Character separating strokes</returns>
        public char GetPenUp()
        {
            return penUp;
        }

        /// <summary>
        /// This method returns the "sentinel" for the stream, the set of
        /// characters immediately following the start character.
        /// </summary>
        /// <returns>The streams sentinel</returns>
        public string GetSentinel()
        {
            return sentinel;
        }

        /// <summary>
        /// This method returns the width of the device's display in pixels.
        /// </summary>
        /// <returns>Width in pixels</returns>
        public virtual int GetWidth()
        {
            return width;
        }

        /// <summary>
        /// This method returns the height of the device's display in pixels.
        /// </summary>
        /// <returns>Height in pixels</returns>
        public virtual int GetHeight()
        {
            return height;
        }

        /// <summary>
        /// This method returns a two dimensional array containing the values
        /// for the high and low x bytes.
        /// </summary>
        /// <returns>Decoding table for X coordinates</returns>
        public byte[][] GetXValues()
        {
            return this.xValues;
        }

        /// <summary>
        /// This method returns a two dimensional array containing the values
        /// for the high and low y bytes.
        /// </summary>
        /// <returns>Decoding table for Y coordinates</returns>
        public byte[][] GetYValues()
        {
            return this.yValues;
        }
    }
}
