﻿// <copyright file="ISignatureProtocol.cs" company="Scriptel Corporation">
//      Copyright 2014 - Scriptel Corporation
// </copyright>
namespace EasyScriptAPI
{
    /// <summary>
    /// This interface represents a Scriptel ScripTouch EasyScript protocol.
    /// </summary>
    public interface ISignatureProtocol
    {
        /// <summary>
        /// This method should return the character that denotes the start of a new
        /// signature.
        /// </summary>
        /// <returns>Character that starts a stream</returns>
        char GetStartStream();

        /// <summary>
        /// This method should return the character that denotes the end of a new
        /// signature.
        /// </summary>
        /// <returns>Character that ends a stream</returns>
        char GetEndStream();

        /// <summary>
        /// This method should return the character that denotes that a signature has been canceled.
        /// </summary>
        /// <returns>Character that ends a stream</returns>
        char GetCancelStream();

        /// <summary>
        /// This method should return the character that denotes a 'pen up' event,
        /// or the start of a new signature.
        /// signature.
        /// </summary>
        /// <returns>Character that denotes a pen up event</returns>
        char GetPenUp();
        
        /// <summary>
        /// This method should return the "sentinel" for the stream, the set of
        /// characters immediately following the start character.
        /// </summary>
        /// <returns>The streams sentinel</returns>
        string GetSentinel();
        
        /// <summary>
        /// This method should return the width of the device's display in pixels.
        /// </summary>
        /// <returns>Width in pixels</returns>
        int GetWidth();

        /// <summary>
        /// This method should return the height of the device's display in pixels.
        /// </summary>
        /// <returns>Height in pixels</returns>
        int GetHeight();

        /// <summary>
        /// This method should return a two dimensional array containing the values 
        /// for the high and low x bytes
        /// </summary>
        /// <returns>Decoding table for the x coordinates</returns>
        byte[][] GetXValues();

        /// <summary>
        /// This method should return a two dimensional array containing the values 
        /// for the high and low y bytes
        /// </summary>
        /// <returns>Decoding table for the y coordinates</returns>
        byte[][] GetYValues();
    }
}
