﻿// <copyright file="Coordinate.cs" company="Scriptel Corporation">
//      Copyright 2014 - Scriptel Corporation
// </copyright>
namespace EasyScriptAPI
{
    using System.Text;

    /// <summary>
    /// This class represents a two dimensional coordinate on a digitizer.
    /// </summary>
    public class Coordinate
    {

        /// <summary>
        /// Initializes a new instance of the <see cref="Coordinate"/> class.
        /// </summary>
        /// <param name="x">the x value of the coordinate</param>
        /// <param name="y">the y value of the coordinate</param>
        public Coordinate(double x, double y)
        {
            this.X = x;
            this.Y = y;
        }

        /// <summary>
        /// The horizontal component of the coordinate.
        /// </summary>
        public double X
        {
            get;
            set;
        }

        /// <summary>
        /// The vertical component of the coordinate.
        /// </summary>
        public double Y
        {
            get;
            set;
        }

        /// <summary>
        /// Returns a string representation of the coordinate
        /// </summary>
        /// <returns>a string representation of the coordinate</returns>
        public override string ToString()
        {
            StringBuilder builder = new StringBuilder();
            builder.Append("{x:").Append(this.X).Append(", y:").Append(this.Y).Append('}');
            return builder.ToString();
        }
    }
}
