<?php
/**
 * This file contains the {@link SignatureProtocol} class.
 * @copyright (c) 2015, Scriptel Corporation.
 */
namespace com\scriptel;

/**
 * This interface represents a Scriptel ScripTouch EasyScript protocol.
 */
interface SignatureProtocol {
    /**
     * This method should return the character that denotes the start of a new
     * signature.
     */
    function getStartStream();
    /**
     * This method should return the character that denotes the end of a stream.
     */
    function getEndStream();
    /**
     * This method should return the character that denotes a "pen up" event,
     * or the start of a new stroke.
     */
    function getPenUp();
    /**
     * This method should return the character that denotes the signature
     * has been canceled.
     */
    function getCancel();
    /**
     * This method should return the "sentinel" for the stream, the set of
     * characters immediately following the start character.
     */
    function getSentinel();
    /**
     * This method should return the width of the device's display in pixels.
     */
    function getWidth();
    /**
     * This method should return the Height of the device's display in pixels.
     */
    function getHeight();
    /**
     * This method should return a two dimensional array containing the values
     * for the high and low x bytes.
     */
    function getXValues();
    /**
     * his method should return a two dimensional array containing the values
     * for the high and low y bytes.
     */
    function getYValues();
}
