<?php
/**
 * This file contains the {@link SignatureInvalidException} class.
 * @copyright (c) 2015, Scriptel Corporation.
 */
namespace com\scriptel;

/**
 * This exception is thrown when there is a problem parsing a signature string.
 */
class SignatureInvalidException extends \Exception {

    /**
     * Constructor, creates a new exception of this type.
     * @param msg Message containing a more detailed description of this error.
     * @param int code Error code
     * @param \Exception previous Previous exception
     */
    public function __construct($msg, $code = 0, $previous = null) {
        parent::__construct($msg, $code, $previous);
    }

    /**
     * Gets a human readable version of this object.
     * @return string A human readable version of this object.
     */
    public function __toString() {
        return __CLASS__ . ": [{$this->code}]:{$this->message}\n";
    }

}
