<?php
/**
 * This file contains the {@link STNSignatureProtocol} class.
 * @copyright (c) 2015, Scriptel Corporation.
 */
namespace com\scriptel;

/**
 * This class implements the STN Protocol for the Scriptel ScripTouch keyboard
 * EasyScript products.
 */
class STNSignatureProtocol implements SignatureProtocol {
    /**
     * The chcaracter that denotes the start of a new signature.
     */
    const START_STREAM = '~';
    /**
     * The chcaracter that denotes the end of a signature.
     */
    const END_STREAM = '`';
    /**
     * The character that denotes a "pen up" event, or the start of a new stroke.
     */
    const PEN_UP = ' ';
    /**
     * The character that denotes the signature has been canceled.
     */
    const CANCEL = '/';
    /**
     * The "sentinel" for the stream, the set of characters immediately following the start character.
     */
    const SENTINEL = 'STSIGN';
    /**
     * The width of the device's display in pixels.
     */
    const WIDTH = 240;
    /**
     * The height of the device's display in pixels.
     */
    const HEIGHT = 64;
    /**
     * A two dimensional array containing the values for the high and low x bytes.
     */
    private $xValues = array(
        array(0x41,0x43,0x45,0x47,0x49,0x4b,0x4d,0x4f,0x51,0x53,0x55,0x57,0x59,0x21,0x23,0x25,0x26,0x28,0x2b,0x7d,0x22,0x3c),
        array(0x42,0x44,0x46,0x48,0x4a,0x4c,0x4e,0x50,0x52,0x54,0x56,0x58,0x5a,0x40,0x24,0x5e,0x2a,0x29,0x5f,0x7b,0x7c,0x3a,0x3e)
    );
    /**
     * A two dimensional array containing the values for the high and low y bytes.
     */
    private $yValues = array(
        array(0x61,0x63,0x65,0x67,0x69,0x6b,0x6d,0x6f,0x71,0x73,0x75,0x77,0x79,0x31,0x33,0x35,0x37,0x39,0x3d,0x5d,0x27,0x2c),
        array(0x62,0x64,0x66,0x68,0x6a,0x6c,0x6e,0x70,0x72,0x74,0x76,0x78,0x7a,0x32,0x34,0x36,0x38,0x30,0x2d,0x5b,0x5c,0x3b,0x2e)
    );
    /**
     * This method returns the character that denotes the signature has been canceled.
     * @return string Cancel character for this protocol.
     */
    public function getCancel() {
        return self::CANCEL;
    }
    /**
     * This method returns the character that denotes the end of a stream.
     * @return string Character that ends a stream.
     */
    public function getEndStream() {
        return self::END_STREAM;
    }
    /**
     * This method should return the height of the device's display in pixels.
     * @return integer Height in pixels.
     */
    public function getHeight() {
        return self::HEIGHT;
    }
    /**
     * This method returns the character that denotes a "pen up" event,
     * or the start of a new stroke.
     * @return string Character separating strokes.
     */
    public function getPenUp() {
        return self::PEN_UP;
    }
    /**
     * This method returns the "sentinel" for the stream, the set of
     * characters immediately following the start character.
     * @return string The streams sentinel.
     */
    public function getSentinel() {
        return self::SENTINEL;
    }
    /**
     * This method returns the character that denotes the start of a new
     * signature.
     * @return string Character that starts a stream.
     */
    public function getStartStream() {
        return self::START_STREAM;
    }
    /**
     * This method returns the width of the device's display in pixels.
     * @return integer Width in pixels.
     */
    public function getWidth() {
        return self::WIDTH;
    }
    /**
     * This method returns a two dimensional array containing the values
     * for the high and low x bytes.
     * @return byte[][] Decoding table for X coordinates.
     */
    public function getXValues() {
        return $this->xValues;
    }
    /**
     * This method returns a two dimensional array containing the values
     * for the high and low y bytes.
     * @return byte[][] Decoding table for the Y coordinates.
     */
    public function getYValues() {
        return $this->yValues;
    }
}
