<?php
/**
 * This file contains the {@link IdentificationSex} class.
 * @copyright (c) 2015, Scriptel Corporation.
 */
namespace com\scriptel;

/**
 * This class represents the gender of a card-holder on an identification card.
 */
abstract class IdentificationSexEnum {
    /**
     * Constructor, creates a new instance of this class.
     * @param string sex The identification sex.
     */
    final public function __construct($sex) {
        $myClass = new \ReflectionClass($this);
        if (!in_array($sex, $myClass->getConstants())) {
            throw InvalidArgumentException();
        }
        $this->sex = $sex;
    }

    /** 
     * Gets the constant of the current sex.
     * @return string Sex constant.
     */
    final public function getSex() {
        return $this->sex;
    }
}

/**
 * This class contains the various constants used by {@link IdentificationSexEnum}.
 */
class IdentificationSex extends IdentificationSexEnum {
    /**
     * Individual is male.
     */
    const MALE = 'M';
    /**
     * Individual is female.
     */
    const FEMALE = 'F';
}