<?php
/**
 * This file contains the {@link EasyScriptEventListener} class.
 * @copyright (c) 2015, Scriptel Corporation.
 */
namespace com\scriptel;

/**
 * This interface defines a listener capable of receiving streaming EasyScript
 * events.
 */
interface EasyScriptEventListener {
   /**
     * This method will be called when a coordinate is parsed from the signature
     * stream.
     * @param Coordinate Most recent coordinate from the signature stream.
     */
    public function receiveCoordinate($coordinate);
    /**
     * This method will be called when a new stroke is detected in the signature
     * stream.
     */
    public function newStroke();
    /**
     * This method will be called when the signature is cancelled by pressing
     * the "Cancel" button on the signature pad.
     */
    public function cancel();
    /**
     * This method will be called when the signature is accepted by pressing the
     * "OK" or "Accept" button on the signature pad.
     */
    public function endOfSignature();
    /**
     * This method is called when the signature metadata is captured from the
     * signature stream.
     * @param SignatureMetaData Metadata regarding the current signature.
     */
    public function signatureMetaData($metaData);
    /**
     * This method is called when a card swipe is detected in the signature
     * stream.
     * @param CardSwipe Card Swipe
     */
    public function cardSwipe($swipe);
}
