<?php
/**
 * This file contains the {@link EasyScriptCardState} class.
 * @copyright (c) 2015, Scriptel Corporation.
 */
namespace com\scriptel;

/**
 * This class represents different states in the card parsing state machine.
 */
abstract class CardStateEnum {
    /**
     * Constructor, creates a new instance of this class.
     * @param string state The card state.
     */
    final public function __construct($state){
        $myClass = new \ReflectionClass($this);
        if (!in_array($state, $myClass->getConstants())) {
            throw InvalidArgumentException();
        }
        $this->state = $state;
    }

    /**
     * This method gets the underlying constant behind this type.
     * @returns string Card State
     */
    final public function getState() {
        return $this->state;
    }
}
/**
 * This class contains the various constants used by {@link CardStateEnum}.
 */
class EasyScriptCardState extends CardStateEnum {
    /**
     * Unknown.
     */
    const UNKNOWN = 'UNKNOWN';
    /**
     * We're expecting card data.
     */
    const CARD_DATA = 'CARD_DATA';
    /**
     * Card data was successfully parsed.
     */
    const CARD_PROCESSED = 'CARD_PROCESSED';
    /**
     * Not a card.
     */
    const NOT_A_CARD = 'NOT_A_CARD';
}
