<?php
/**
 * This file contains the {@link Coordinate} class.
 * @copyright (c) 2015, Scriptel Corporation.
 */
namespace com\scriptel;

/**
 * This class represents a two dimensional coordinate on a digitizer.
 */
class Coordinate {
    /**
     * The horizontal coordinate.
     * @var float
     */
    private $x;
    /**
     * The vertical coordinate.
     * @var float
     */
    private $y;
    /**
     * Constructor, creates a new instance of this class.
     * @param float $x The horizontal component.
     * @param float $y The vertical component.
     */
    public function __construct($x, $y) {
        $this->x = $x;
        $this->y = $y;
    }

    /**
     * Gets the horizontal component.
     * @return float
     */
    function getX() {
        return $this->x;
    }

    /**
     * Gets the vertical component.
     * @return float
     */
    function getY() {
        return $this->y;
    }

    /**
     * Sets the horizontal component.
     * @param float $x
     */
    function setX($x) {
        $this->x = $x;
    }

    /**
     * Set the vertical component.
     * @param float $y
     */
    function setY($y) {
        $this->y = $y;
    }
}
