<?php
/**
 * This file contains the {@link BinaryTree} class.
 * @copyright (c) 2015, Scriptel Corporation.
 */
namespace com\scriptel;

/**
 * This class represents a binary tree
 */
class BinaryTree {
    /**
     * If this node is a leaf, this contains the value of the leaf.
     * @var integer
     */
    private $value;
    /**
     * If this node is a branch this contains the left node.
     * @var BinaryTree
     */
    private $left;
    /**
     * If this node is a branch this contains the right node.
     * @var BinaryTree
     */
    private $right;

    /**
     * Constructor, creates a new instance of BinaryTree class.
     */
    public function __construct() {
        $this->value = 0;
        $this->left = NULL;
        $this->right = NULL;
    }

    /**
     * This method returns the value of a leaf.
     * @return integer
     */
    public function getValue() {
        return $this->value;
    }

    /**
     * This method returns the left child node (binary tree) of the current node.
     * @return BinaryTree
     */
    public function getLeft() {
        return $this->left;
    }

    /**
     * This method returns the right child node (binary tree) of the current node.
     * @return BinrayTree
     */
    public function getRight() {
        return $this->right;
    }

    /**
     * This method sets a value of this leaf.
     * @param integer $value
     */
    public function setValue($value) {
        $this->value = $value;
    }

    /**
     * This method sets the left child node (binary tree) of the current node.
     * @param BinaryTree $left
     */
    public function setLeft($left) {
        $this->left = $left;
    }

    /**
     * This method sets the right child node (binary tree) of the current node.
     * @param BinaryTree $right
     */
    public function setRight($right) {
        $this->right = $right;
    }
}
