/*
 * Copyright 2013 - Scriptel Corporation
 */
package com.scriptel.easyscript.signatureprotocols;

import com.scriptel.easyscript.SignatureProtocol;

/**
 * This class implements the STN Protocol for the Scriptel ScripTouch keyboard
 * EasyScript products.
 */
public class STNSignatureProtocol implements SignatureProtocol {
    private static final char START_STREAM = '~';
    private static final char END_STREAM = '`';
    private static final char PEN_UP = ' ';
    private static final char CANCEL = '/';
    private static final String SENTINEL = "STSIGN";
    private static final int width = 240;
    private static final int height = 64;
    
    private static final byte[][] X_VALUES = {
        {0x41,0x43,0x45,0x47,0x49,0x4b,0x4d,0x4f,0x51,0x53,0x55,0x57,0x59,0x21,0x23,0x25,0x26,0x28,0x2b,0x7d,0x22,0x3c},
        {0x42,0x44,0x46,0x48,0x4a,0x4c,0x4e,0x50,0x52,0x54,0x56,0x58,0x5a,0x40,0x24,0x5e,0x2a,0x29,0x5f,0x7b,0x7c,0x3a,0x3e}
    };
    private static final byte[][] Y_VALUES = {
        {0x61,0x63,0x65,0x67,0x69,0x6b,0x6d,0x6f,0x71,0x73,0x75,0x77,0x79,0x31,0x33,0x35,0x37,0x39,0x3d,0x5d,0x27,0x2c},
        {0x62,0x64,0x66,0x68,0x6a,0x6c,0x6e,0x70,0x72,0x74,0x76,0x78,0x7a,0x32,0x34,0x36,0x38,0x30,0x2d,0x5b,0x5c,0x3b,0x2e}
    };    

    /**
     * This method returns the character that denotes the start of a new 
     * signature.
     * @return Character that starts a stream.
     */
    @Override
    public char getStartStream() {
        return START_STREAM;
    }

    /**
     * This method returns the character that denotes the end of a stream.
     * @return Character that ends a stream.
     */
    @Override
    public char getEndStream() {
        return END_STREAM;
    }

    /**
     * This method returns the character that denotes a "pen up" event,
     * or the start of a new stroke.
     * @return Character separating strokes.
     */
    @Override
    public char getPenUp() {
        return PEN_UP;
    }

    /**
     * This method returns the "sentinel" for the stream, the set of
     * characters immediately following the start character.
     * @return The streams sentinel.
     */
    @Override
    public String getSentinel() {
        return SENTINEL;
    }

    /**
     * This method returns the width of the device's display in pixels.
     * @return Width in pixels.
     */
    @Override
    public int getWidth() {
        return width;
    }

    /**
     * This method should return the width of the device's display in pixels.
     * @return Height in pixels.
     */
    @Override
    public int getHeight() {
        return height;
    }

    /**
     * This method returns a two dimensional array containing the values
     * for the high and low x bytes.
     * @return Decoding table for X coordinates.
     */
    @Override
    public byte[][] getXValues() {
        return X_VALUES;
    }

    /**
     * This method returns a two dimensional array containing the values
     * for the high and low y bytes.
     * @return Decoding table for the Y coordinates.
     */
    @Override
    public byte[][] getYValues() {
        return Y_VALUES;
    }

    /**
     * This method gets the cancel character for this protocol.
     * @return Cancel character for this protocol.
     */
    @Override
    public char getCancel() {
        return CANCEL;
    }
}
