/*
 * Copyright 2013 - Scriptel Corporation
 */
package com.scriptel.easyscript;

/**
 * This interface represents a Scriptel ScripTouch EasyScript protocol.
 */
public interface SignatureProtocol {
    /**
     * This method should return the character that denotes the start of a new
     * signature.
     * @return Character that starts a stream.
     */
    char getStartStream();
    /**
     * This method should return the character that denotes the end of a stream.
     * @return Character that ends a stream.
     */
    char getEndStream();
    /**
     * This method should return the character that denotes a "pen up" event,
     * or the start of a new stroke.
     * @return Character separating strokes.
     */
    char getPenUp();
    /**
     * This method should return the character that denotes the signature
     * has been canceled.
     * @return Character indicating signature has been canceled.
     */
    char getCancel();
    /**
     * This method should return the "sentinel" for the stream, the set of
     * characters immediately following the start character.
     * @return The streams sentinel.
     */
    String getSentinel();
    /**
     * This method should return the width of the device's display in pixels.
     * @return Width in pixels.
     */
    int getWidth();
    /**
     * This method should return the width of the device's display in pixels.
     * @return Height in pixels.
     */
    int getHeight();
    /**
     * This method should return a two dimensional array containing the values
     * for the high and low x bytes.
     * @return Decoding table for X coordinates.
     */
    byte[][] getXValues();
    /**
     * This method should return a two dimensional array containing the values
     * for the high and low y bytes.
     * @return Decoding table for the Y coordinates.
     */
    byte[][] getYValues();
}
