/*
 * Copyright 2013 - Scriptel Corporation
 */
package com.scriptel.easyscript.example;

import com.scriptel.easyscript.EasyScript;
import com.scriptel.easyscript.Signature;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * A quick example showing how to use the EasyScript device in Java in a Servlet
 * environment.
 */
@WebServlet(name = "Example", urlPatterns = {"/"})
public class Example extends HttpServlet {
    /**
     * Handles the normal browser "GET" method and returns a web page. Just loads
     * "index.html".
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html;charset=UTF-8");
        InputStream io = null;
        OutputStream os = response.getOutputStream();
        try {
            io = Example.class.getResourceAsStream("index.html");
            int count;
            byte[] buffer = new byte[512];
            while((count=io.read(buffer))>0) {
                os.write(buffer,0,count);
            }
        } catch(IOException e) {
            os.write(("Something bad happened (GET): "+e.getMessage()).getBytes());
        } finally {
            if(io!=null) { try { io.close(); } catch(Exception e) {} }
        }
    }

    /**
     * Handles the "POST" method where we're handing an EasyScript string submitted
     * through a form.
     * @param request servlet request
     * @param response servlet response
     * @throws ServletException if a servlet-specific error occurs
     * @throws IOException if an I/O error occurs
     */
    @Override
    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String esString = request.getParameter("easyscript_string");
        response.setContentType("image/png");
            OutputStream os = response.getOutputStream();
            try {
                EasyScript eScript = new EasyScript();
                Signature signature = eScript.parseSignature(esString);
                BufferedImage image = eScript.renderSignature(signature, Color.black, null, 2, 3);
                ImageIO.write(image, "png", os);
            } catch(Exception e) {
                os.write(("Something bad happened (POST): "+e.getMessage()).getBytes());
            } finally {
                try { os.close(); } catch(IOException e) {}
            }
    }

    /**
     * Returns a short description of the servlet.
     *
     * @return a String containing servlet description
     */
    @Override
    public String getServletInfo() {
        return "Example of how to use EasyScript in a Servlet Environment.";
    }
}
