/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.easyscript.example;

import com.scriptel.easyscript.CardSwipe;
import com.scriptel.easyscript.Coordinate;
import com.scriptel.easyscript.EasyScript;
import com.scriptel.easyscript.EasyScriptEventListener;
import com.scriptel.easyscript.SignatureInvalidException;
import com.scriptel.easyscript.SignatureMetaData;
import com.scriptel.easyscript.example.ExampleForm;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.geom.Line2D;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class Example
implements EasyScriptEventListener {
    private final ExampleForm form = new ExampleForm();
    private final EasyScript easyScript;
    private static final int SCALE = 2;
    private static final int WIDTH = 480;
    private static final int HEIGHT = 128;
    private static final int LINE_THICKNESS = 2;
    private static final Color BACK_COLOR = Color.WHITE;
    private static final Color FORE_COLOR = Color.BLACK;
    private final Graphics2D g;
    private Coordinate previousCoordinate;
    private int strokeCount;

    public Example() {
        this.form.setVisible(true);
        this.g = (Graphics2D)this.form.getCanvas().getGraphics();
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        this.g.setStroke(new BasicStroke(2.0f));
        this.easyScript = new EasyScript();
        this.easyScript.addListener(this);
        KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        mgr.addKeyEventDispatcher(new ScriptelKeyboardDispatcher());
    }

    public static void main(String[] args) {
        Example demo = new Example();
        demo.clear();
    }

    private void clear() {
        this.previousCoordinate = null;
        this.strokeCount = 1;
        this.form.getTextArea().setText("Instructions:\n-Make sure this window has focus.\n-Sign or Swipe, the gathered information will be shown here.");
        this.g.setColor(BACK_COLOR);
        this.g.fillRect(0, 0, 480, 128);
        this.g.setColor(FORE_COLOR);
    }

    @Override
    public void receiveCoordinate(Coordinate coordinate) {
        double x2 = coordinate.getX() * 2.0;
        double y2 = coordinate.getY() * 2.0;
        this.form.getTextArea().append("      {x:" + x2 + ", y:" + y2 + "}\n");
        if (this.previousCoordinate != null) {
            double x1 = this.previousCoordinate.getX() * 2.0;
            double y1 = this.previousCoordinate.getY() * 2.0;
            this.g.draw(new Line2D.Double(x1, y1, x2, y2));
        }
        this.previousCoordinate = coordinate;
    }

    @Override
    public void newStroke() {
        this.form.getTextArea().append("\n Stroke " + this.strokeCount++ + ":\n");
        this.previousCoordinate = null;
    }

    @Override
    public void cancel() {
        this.clear();
    }

    @Override
    public void endOfSignature() {
    }

    @Override
    public void signatureMetaData(SignatureMetaData header) {
        this.clear();
        StringBuilder sb = new StringBuilder();
        sb.append("Scriptel EasyScript Signature:\n");
        sb.append("  Protocol Version: ").append(header.getProtocolVersion()).append("\n");
        sb.append("      Device Model: ").append(header.getModel()).append("\n");
        sb.append("  Firmware Version: ").append(header.getVersion()).append("\n\n");
        this.form.getTextArea().append(sb.toString());
    }

    @Override
    public void cardSwipe(CardSwipe swipe) {
        this.form.getTextArea().setText(swipe.toString());
    }

    private void handleException(Exception e) {
        this.clear();
        StringWriter writer = new StringWriter();
        PrintWriter wrapper = new PrintWriter(writer);
        e.printStackTrace(wrapper);
        this.form.getTextArea().setText(writer.toString());
        wrapper.close();
        try {
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class ScriptelKeyboardDispatcher
    implements KeyEventDispatcher {
        private ScriptelKeyboardDispatcher() {
        }

        @Override
        public boolean dispatchKeyEvent(KeyEvent ke) {
            try {
                Example.this.easyScript.parse(ke);
            }
            catch (SignatureInvalidException e) {
                Example.this.handleException(e);
            }
            return false;
        }
    }
}

