/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.easyscript;

import com.scriptel.easyscript.BinaryTree;
import com.scriptel.easyscript.BinaryTreeReader;
import com.scriptel.easyscript.Coordinate;
import com.scriptel.easyscript.EasyScriptDecoder;
import com.scriptel.easyscript.EasyScriptEventListener;
import com.scriptel.easyscript.KeyboardDecoder;
import com.scriptel.easyscript.SignatureInvalidException;
import com.scriptel.easyscript.SignatureProtocol;
import java.util.LinkedList;
import java.util.List;

public final class EasyScriptCompressedDecoder
implements EasyScriptDecoder {
    private static final int MAXIMUM_COMPRESSED_VALUE = 2999;
    private static final int REPEAT_HALF = 59;
    private static final int NEW_STROKE_CODE = 60;
    private static final int REVERSE_X_CODE = 61;
    private static final int REVERSE_Y_CODE = 62;
    private static final int REVERSE_X_AND_Y_CODE = 63;
    private static final int REVERSE_X_CODE_SWAP = 3001;
    private static final int REVERSE_Y_CODE_SWAP = 3002;
    private static final int REVERSE_X_AND_Y_CODE_SWAP = 3003;
    private static final int REPEAT_HALF_SWAP = 3004;
    private static final int NEW_STROKE_CODE_SWAP = 3005;
    private static final int CANCEL_CODE = 3007;
    private final BinaryTreeReader tree = new BinaryTreeReader();
    protected List<EasyScriptEventListener> coordinateReceiverListeners = null;
    private final StringBuilder streamedSignature = new StringBuilder();
    private final LinkedList<Boolean> stream;
    private final SignatureProtocol signatureProtocol;
    private final KeyboardDecoder keyboardDecoder;
    private boolean decodingX = true;
    private int xSign = 1;
    private int ySign = 1;
    private int previousX = 0;
    private int previousY = 0;
    private int charPosition;
    private BinaryTree nodePointer;
    private int makeupValue;
    private int x;
    private int y;
    private final Coordinate currentPoint = new Coordinate(0.0, 0.0);
    boolean isMakeupCode = false;
    boolean isNewStroke = true;

    public EasyScriptCompressedDecoder(SignatureProtocol signatureProtocol, int position, List<EasyScriptEventListener> listOfCoordinateReceiverListener) {
        this.coordinateReceiverListeners = listOfCoordinateReceiverListener;
        this.signatureProtocol = signatureProtocol;
        this.stream = new LinkedList();
        this.charPosition = position;
        this.keyboardDecoder = new KeyboardDecoder(this.getSignatureProtocol().getXValues(), this.getSignatureProtocol().getYValues());
        this.nodePointer = this.tree.getTree();
    }

    protected int searchBinaryTree(List<Boolean> stream) {
        while (!stream.isEmpty()) {
            boolean currentBit = stream.get(0);
            this.nodePointer = currentBit ? this.nodePointer.getRight() : this.nodePointer.getLeft();
            stream.remove(0);
            if (this.nodePointer.getLeft() != null || this.nodePointer.getRight() != null) continue;
            int value = this.nodePointer.getValue();
            this.nodePointer = this.tree.getTree();
            return value;
        }
        return -1;
    }

    private void addValueToSignature(int byteOfBitStream) throws SignatureInvalidException {
        this.addValueToStream(byteOfBitStream);
        int value = 0;
        block17: while (!this.stream.isEmpty()) {
            if (!this.isMakeupCode) {
                value = this.searchBinaryTree(this.stream);
                if (value < 0) {
                    return;
                }
                if (value >= 64) {
                    this.makeupValue = value;
                    this.isMakeupCode = true;
                } else {
                    this.makeupValue = 0;
                }
            }
            if (this.isMakeupCode) {
                value = this.searchBinaryTree(this.stream);
                if (value < 0) {
                    return;
                }
                value += this.makeupValue;
                this.isMakeupCode = false;
                this.makeupValue = 0;
            }
            if (this.decodingX) {
                switch (value) {
                    case 60: {
                        this.isNewStroke = true;
                        continue block17;
                    }
                    case 3007: {
                        for (EasyScriptEventListener listener : this.coordinateReceiverListeners) {
                            listener.cancel();
                        }
                        continue block17;
                    }
                    case 61: {
                        this.xSign = -this.xSign;
                        continue block17;
                    }
                    case 62: {
                        this.ySign = -this.ySign;
                        continue block17;
                    }
                    case 63: {
                        this.xSign = -this.xSign;
                        this.ySign = -this.ySign;
                        continue block17;
                    }
                    case 59: {
                        this.x = this.previousX;
                        this.decodingX = false;
                        continue block17;
                    }
                    case 3004: {
                        this.x = 59;
                        this.decodingX = false;
                        continue block17;
                    }
                    case 3001: {
                        this.x = 61;
                        this.decodingX = false;
                        continue block17;
                    }
                    case 3002: {
                        this.x = 62;
                        this.decodingX = false;
                        continue block17;
                    }
                    case 3003: {
                        this.x = 63;
                        this.decodingX = false;
                        continue block17;
                    }
                    case 3005: {
                        this.x = 60;
                        this.decodingX = false;
                        continue block17;
                    }
                }
                this.x = value;
                this.decodingX = false;
                continue;
            }
            switch (value) {
                case 59: {
                    this.y = this.previousY;
                    break;
                }
                case 3004: {
                    this.y = 59;
                    break;
                }
                default: {
                    this.previousY = this.y = value;
                }
            }
            this.decodingX = true;
            this.previousX = this.x;
            this.x *= this.xSign;
            this.y *= this.ySign;
            this.currentPoint.setX(this.currentPoint.getX() + (double)this.x);
            this.currentPoint.setY(this.currentPoint.getY() + (double)this.y);
            this.x = 0;
            this.y = 0;
            if (this.isNewStroke) {
                for (EasyScriptEventListener listener : this.coordinateReceiverListeners) {
                    listener.newStroke();
                }
                this.isNewStroke = false;
            }
            Coordinate scaledCoordinate = new Coordinate(this.currentPoint.getX() * (double)this.signatureProtocol.getWidth() / 2999.0, this.currentPoint.getY() * (double)this.signatureProtocol.getHeight() / 2999.0);
            for (EasyScriptEventListener listener : this.coordinateReceiverListeners) {
                listener.receiveCoordinate(scaledCoordinate);
            }
        }
    }

    protected int convertBodnarCharsToValue(StringBuilder signature) throws SignatureInvalidException {
        int value;
        block4: {
            if (signature.length() < 2) {
                return -1;
            }
            try {
                value = this.keyboardDecoder.getValue(signature.charAt(0)) + this.keyboardDecoder.getValue(signature.charAt(1));
                if (value != 505) break block4;
                if (signature.length() > 2) {
                    value += this.keyboardDecoder.getValue(signature.charAt(2));
                    break block4;
                }
                return -1;
            }
            catch (SignatureInvalidException ex) {
                SignatureInvalidException rethrow = new SignatureInvalidException(ex.toString(), this.charPosition);
                rethrow.initCause(ex);
                throw rethrow;
            }
        }
        return value;
    }

    public SignatureProtocol getSignatureProtocol() {
        return this.signatureProtocol;
    }

    private void addValueToStream(int decNumber) {
        String binary = Integer.toBinaryString(decNumber);
        binary = "000000000".substring(binary.length()) + binary;
        for (int i = 0; i < binary.length(); ++i) {
            boolean currentBit = binary.charAt(i) != '0';
            this.stream.add(currentBit);
        }
    }

    @Override
    public void parseSignature(char ch) throws SignatureInvalidException {
        ++this.charPosition;
        if (ch == this.signatureProtocol.getEndStream()) {
            for (EasyScriptEventListener listener : this.coordinateReceiverListeners) {
                listener.endOfSignature();
            }
            return;
        }
        if (ch == this.signatureProtocol.getCancel()) {
            for (EasyScriptEventListener listener : this.coordinateReceiverListeners) {
                listener.cancel();
            }
            return;
        }
        this.streamedSignature.append(ch);
        if (this.streamedSignature.length() < 2) {
            return;
        }
        int result = this.convertBodnarCharsToValue(this.streamedSignature);
        if (result >= 0) {
            this.addValueToSignature(result);
            this.streamedSignature.setLength(0);
        }
    }
}

