/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.easyscript;

import com.scriptel.easyscript.Coordinate;
import com.scriptel.easyscript.SignatureMetaData;
import java.util.List;

public class Signature {
    private final String protocolVersion;
    private final String model;
    private final String version;
    private final List<List<Coordinate>> strokes;

    public Signature(SignatureMetaData metaData, List<List<Coordinate>> strokes) {
        this.protocolVersion = metaData.getProtocolVersion();
        this.model = metaData.getModel();
        this.version = metaData.getVersion();
        this.strokes = strokes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Scriptel EasyScript Signature:\n");
        sb.append("   Protocol Version: ").append(this.protocolVersion).append("\n");
        sb.append("       Device Model: ").append(this.model).append("\n");
        sb.append("   Firmware Version: ").append(this.version).append("\n");
        sb.append("            Strokes: \n");
        for (int x = 0; x < this.strokes.size(); ++x) {
            sb.append("   Stroke ").append(x).append(":\n");
            for (Coordinate c : this.strokes.get(x)) {
                sb.append("      ").append(c).append("\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public String getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getModel() {
        return this.model;
    }

    public String getVersion() {
        return this.version;
    }

    public SignatureMetaData getMetaData() {
        return new SignatureMetaData(this.getProtocolVersion(), this.getModel(), this.getVersion());
    }

    public List<List<Coordinate>> getStrokes() {
        return this.strokes;
    }
}

