/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.easyscript;

import com.scriptel.easyscript.Coordinate;
import com.scriptel.easyscript.EasyScriptDecoder;
import com.scriptel.easyscript.EasyScriptEventListener;
import com.scriptel.easyscript.KeyboardDecoder;
import com.scriptel.easyscript.SignatureInvalidException;
import com.scriptel.easyscript.SignatureProtocol;
import java.util.ArrayList;
import java.util.List;

public class EasyScriptUncompressedDecoder
implements EasyScriptDecoder {
    private static final int MAX_NUM = 505;
    private final SignatureProtocol signatureProtocol;
    private int position;
    private List<EasyScriptEventListener> coordinateReceiverListeners;
    private final StringBuilder signatureBuilder = new StringBuilder(4);
    private final KeyboardDecoder keyboardDecoder;
    private boolean newStroke;

    public EasyScriptUncompressedDecoder(SignatureProtocol signatureProtocol, int position, List<EasyScriptEventListener> listOfCoordinateReceiverListener) {
        this.coordinateReceiverListeners = listOfCoordinateReceiverListener;
        this.signatureProtocol = signatureProtocol;
        this.newStroke = true;
        this.signatureBuilder.setLength(0);
        if (this.coordinateReceiverListeners == null) {
            this.coordinateReceiverListeners = new ArrayList<EasyScriptEventListener>();
        }
        this.position = position;
        this.keyboardDecoder = new KeyboardDecoder(signatureProtocol.getXValues(), signatureProtocol.getYValues());
    }

    protected Coordinate decodePoint(char[] ePoint) throws SignatureInvalidException {
        int[] values;
        if (ePoint.length != 4) {
            throw new SignatureInvalidException("Didn't find exactly 4 characters", this.position);
        }
        try {
            values = this.keyboardDecoder.getValues(ePoint);
        }
        catch (SignatureInvalidException ex) {
            SignatureInvalidException rethrow = new SignatureInvalidException(ex.getMessage(), this.position);
            rethrow.initCause(ex);
            throw rethrow;
        }
        double x = (double)values[0] / 505.0 * (double)this.signatureProtocol.getWidth();
        double y = (double)values[1] / 505.0 * (double)this.signatureProtocol.getHeight();
        return new Coordinate(x, y);
    }

    public SignatureProtocol getSignatureProtocol() {
        return this.signatureProtocol;
    }

    @Override
    public void parseSignature(char ch) throws SignatureInvalidException {
        block7: {
            block9: {
                block8: {
                    block6: {
                        ++this.position;
                        if (ch != this.signatureProtocol.getPenUp()) break block6;
                        this.newStroke = true;
                        if (this.signatureBuilder.length() != 0) {
                            throw new SignatureInvalidException("Buffer wasn't empty when a new stroke was found.", this.position);
                        }
                        break block7;
                    }
                    if (ch != this.signatureProtocol.getEndStream()) break block8;
                    for (EasyScriptEventListener r : this.coordinateReceiverListeners) {
                        r.endOfSignature();
                    }
                    break block7;
                }
                if (ch != this.signatureProtocol.getCancel()) break block9;
                for (EasyScriptEventListener r : this.coordinateReceiverListeners) {
                    r.cancel();
                }
                break block7;
            }
            this.signatureBuilder.append(ch);
            if (this.signatureBuilder.length() != 4) break block7;
            Coordinate c = this.decodePoint(new char[]{this.signatureBuilder.charAt(0), this.signatureBuilder.charAt(1), this.signatureBuilder.charAt(2), this.signatureBuilder.charAt(3)});
            this.signatureBuilder.setLength(0);
            if (this.newStroke) {
                for (EasyScriptEventListener r : this.coordinateReceiverListeners) {
                    r.newStroke();
                }
                this.newStroke = false;
            }
            for (EasyScriptEventListener r : this.coordinateReceiverListeners) {
                r.receiveCoordinate(c);
            }
        }
    }
}

