/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.easyscript;

import com.scriptel.easyscript.SignatureInvalidException;
import java.util.HashMap;
import java.util.Map;

public class KeyboardDecoder {
    private static final int X = 1;
    private static final int Y = 2;
    private static final int MSD = 4;
    private static final int LSD = 8;
    private final Map<Integer, KeyboardValue> values = new HashMap<Integer, KeyboardValue>();

    public KeyboardDecoder(byte[][] xValues, byte[][] yValues) {
        int i;
        for (i = 0; i < xValues[0].length; ++i) {
            this.values.put(Integer.valueOf(xValues[0][i]), new KeyboardValue(i * 23, 5));
            this.values.put(Integer.valueOf(yValues[0][i]), new KeyboardValue(i * 23, 6));
        }
        for (i = 0; i < xValues[1].length; ++i) {
            this.values.put(Integer.valueOf(xValues[1][i]), new KeyboardValue(i, 9));
            this.values.put(Integer.valueOf(yValues[1][i]), new KeyboardValue(i, 10));
        }
    }

    public int getValue(char c) throws SignatureInvalidException {
        KeyboardValue value = this.values.get(c);
        if (value == null) {
            throw new SignatureInvalidException("Unable to map character '" + c + "' to a value in the signature protocol table.", 0);
        }
        return value.getValue();
    }

    public int[] getValues(char[] chrs) throws SignatureInvalidException {
        if (chrs.length != 4) {
            throw new IllegalArgumentException("Character array length was not what was expected (4): " + chrs.length);
        }
        int[] retr = new int[2];
        boolean hasYLSD = false;
        boolean hasYMSD = false;
        boolean hasXLSD = false;
        boolean hasXMSD = false;
        block6: for (int i = 0; i < chrs.length; ++i) {
            KeyboardValue val = this.values.get(chrs[i]);
            if (val == null) {
                throw new SignatureInvalidException("Unable to map character '" + chrs[i] + "' to a value in the signature protocol table.", 0);
            }
            int type = val.getType();
            switch (type) {
                case 5: {
                    retr[0] = retr[0] + val.getValue();
                    hasXMSD = true;
                    continue block6;
                }
                case 9: {
                    retr[0] = retr[0] + val.getValue();
                    hasXLSD = true;
                    continue block6;
                }
                case 6: {
                    retr[1] = retr[1] + val.getValue();
                    hasYMSD = true;
                    continue block6;
                }
                case 10: {
                    retr[1] = retr[1] + val.getValue();
                    hasYLSD = true;
                    continue block6;
                }
                default: {
                    throw new SignatureInvalidException("Detected strange type: " + this.getTypeName(type), 0);
                }
            }
        }
        if (!(hasXMSD && hasXLSD && hasYMSD && hasYLSD)) {
            throw new SignatureInvalidException("Missing required coordinate component.", 0);
        }
        return retr;
    }

    private String getTypeName(int type) {
        String retr = (type & 4) > 0 ? "Most significant digit" : "Least significant digit";
        retr = retr + " of the coordinate on the ";
        retr = retr + ((type & 1) > 0 ? "X-axis" : "Y-axis");
        return retr;
    }

    private class KeyboardValue {
        private final int value;
        private final int type;

        public KeyboardValue(int value, int type) {
            this.value = value;
            this.type = type;
        }

        public int getValue() {
            return this.value;
        }

        public int getType() {
            return this.type;
        }
    }
}

