/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.easyscript;

import com.scriptel.easyscript.IdentificationSex;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class IdentificationCardTrackThree {
    private String cdsVersion;
    private String jurisdictionVersion;
    private String postalCode;
    private String licenseClass;
    private String restrictions;
    private String endorsements;
    private IdentificationSex sex;
    private String height;
    private String weight;
    private String hairColor;
    private String eyeColor;
    private String discretionaryData;

    public static IdentificationCardTrackThree parse(String trackData) {
        Pattern p = Pattern.compile(".*%([0-9]{1})([0-9]{1})([A-Z 0-9]{11})([A-Z 0-9]{2})([A-Z 0-9]{10})([A-Z 0-9]{4})(1|2|M|F)([0-9 ]{3})([0-9 ]{3})([A-Z ]{3})([A-Z ]{3})([^\\?]{0,37})\\?.*");
        Matcher m = p.matcher(trackData);
        if (m.matches()) {
            IdentificationCardTrackThree track = new IdentificationCardTrackThree();
            track.setCdsVersion(m.group(1));
            track.setJurisdictionVersion(m.group(2));
            track.setPostalCode(m.group(3));
            track.setLicenseClass(m.group(4).trim());
            track.setRestrictions(m.group(5).trim());
            track.setEndorsements(m.group(6).trim());
            track.setHeight(m.group(8).trim());
            track.setWeight(m.group(9).trim());
            track.setHairColor(m.group(10).trim());
            track.setEyeColor(m.group(11).trim());
            track.setDiscretionaryData(m.group(12));
            char s = m.group(7).charAt(0);
            IdentificationSex sex = s == '1' || s == 'M' ? IdentificationSex.MALE : IdentificationSex.FEMALE;
            track.setSex(sex);
            return track;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String ln = System.getProperty("line.separator");
        sb.append("Identification Card - Track Three:").append(ln);
        sb.append("         CDS Version: ").append(this.cdsVersion).append(ln);
        sb.append("Jurisdiction Version: ").append(this.jurisdictionVersion).append(ln);
        sb.append("         Postal Code: ").append(this.postalCode).append(ln);
        sb.append("       License Class: ").append(this.licenseClass).append(ln);
        sb.append("        Restrictions: ").append(this.restrictions).append(ln);
        sb.append("        Endorsements: ").append(this.endorsements).append(ln);
        sb.append("                 Sex: ").append((Object)this.sex).append(ln);
        sb.append("              Height: ").append(this.height).append(ln);
        sb.append("              Weight: ").append(this.weight).append(ln);
        sb.append("          Hair Color: ").append(this.hairColor).append(ln);
        sb.append("           Eye Color: ").append(this.eyeColor).append(ln);
        sb.append("  Discretionary Data: ").append(this.discretionaryData).append(ln);
        return sb.toString();
    }

    public String getCdsVersion() {
        return this.cdsVersion;
    }

    private void setCdsVersion(String cdsVersion) {
        this.cdsVersion = cdsVersion;
    }

    public String getJurisdictionVersion() {
        return this.jurisdictionVersion;
    }

    private void setJurisdictionVersion(String jurisdictionVersion) {
        this.jurisdictionVersion = jurisdictionVersion;
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    private void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public String getLicenseClass() {
        return this.licenseClass;
    }

    private void setLicenseClass(String licenseClass) {
        this.licenseClass = licenseClass;
    }

    public String getRestrictions() {
        return this.restrictions;
    }

    private void setRestrictions(String restrictions) {
        this.restrictions = restrictions;
    }

    public String getEndorsements() {
        return this.endorsements;
    }

    private void setEndorsements(String endorsements) {
        this.endorsements = endorsements;
    }

    public IdentificationSex getSex() {
        return this.sex;
    }

    private void setSex(IdentificationSex sex) {
        this.sex = sex;
    }

    public String getHeight() {
        return this.height;
    }

    private void setHeight(String height) {
        this.height = height;
    }

    public String getWeight() {
        return this.weight;
    }

    private void setWeight(String weight) {
        this.weight = weight;
    }

    public String getHairColor() {
        return this.hairColor;
    }

    private void setHairColor(String hairColor) {
        this.hairColor = hairColor;
    }

    public String getEyeColor() {
        return this.eyeColor;
    }

    private void setEyeColor(String eyeColor) {
        this.eyeColor = eyeColor;
    }

    public String getDiscretionaryData() {
        return this.discretionaryData;
    }

    private void setDiscretionaryData(String discretionaryData) {
        this.discretionaryData = discretionaryData;
    }
}

