/*
 * Decompiled with CFR 0.152.
 */
package com.scriptel.easyscript;

import com.scriptel.easyscript.CardSwipe;
import com.scriptel.easyscript.CardSwipeInvalidException;
import com.scriptel.easyscript.CardSwipeProtocol;
import com.scriptel.easyscript.Coordinate;
import com.scriptel.easyscript.EasyScriptCardState;
import com.scriptel.easyscript.EasyScriptCompressedDecoder;
import com.scriptel.easyscript.EasyScriptDecoder;
import com.scriptel.easyscript.EasyScriptEventListener;
import com.scriptel.easyscript.EasyScriptStreamingState;
import com.scriptel.easyscript.EasyScriptUncompressedDecoder;
import com.scriptel.easyscript.FinancialCard;
import com.scriptel.easyscript.IdentificationCard;
import com.scriptel.easyscript.Signature;
import com.scriptel.easyscript.SignatureInvalidException;
import com.scriptel.easyscript.SignatureMetaData;
import com.scriptel.easyscript.SignatureProtocol;
import com.scriptel.easyscript.cardswipeprotocols.STNCardSwipeProtocol;
import com.scriptel.easyscript.signatureprotocols.STNSignatureProtocol;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public final class EasyScript {
    public static final String LIBRARY_VERSION = "3.5.29";
    public static final String LIBRARY_BUILD_DATE = "2022-08-30 17:12:23-0400";
    private SignatureProtocol signatureProtocol;
    private CardSwipeProtocol cardProtocol;
    private final StringBuilder signatureBuffer = new StringBuilder();
    private SignatureMetaData metadata;
    private EasyScriptDecoder decoder;
    private final List<EasyScriptEventListener> eventListeners = new ArrayList<EasyScriptEventListener>();
    private EasyScriptStreamingState currentState = EasyScriptStreamingState.UNKNOWN;
    private int currentPosition = 0;
    private final EndOfStreamListener endListener = new EndOfStreamListener();
    private EasyScriptCardState cardState = EasyScriptCardState.UNKNOWN;
    private final StringBuilder cardBuffer = new StringBuilder();
    private boolean intercepting = false;

    public EasyScript() {
        this(new STNSignatureProtocol(), new STNCardSwipeProtocol());
    }

    public EasyScript(SignatureProtocol signatureProtocol, CardSwipeProtocol cardProtocol) {
        this.signatureProtocol = signatureProtocol;
        this.cardProtocol = cardProtocol;
        if (this.signatureProtocol == null) {
            this.signatureProtocol = new STNSignatureProtocol();
        }
        if (this.cardProtocol == null) {
            this.cardProtocol = new STNCardSwipeProtocol();
        }
        this.addListener(this.endListener);
    }

    public BufferedImage renderSignature(Signature s, Color foreColor, Color backColor, int lineThickness, float scale) {
        int width = (int)((float)this.signatureProtocol.getWidth() * scale);
        int height = (int)((float)this.signatureProtocol.getHeight() * scale);
        BufferedImage image = new BufferedImage(width, height, 2);
        Graphics2D g = (Graphics2D)image.getGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setStroke(new BasicStroke(lineThickness));
        if (backColor != null) {
            g.setColor(backColor);
            g.fillRect(0, 0, width, height);
        }
        g.setColor(foreColor);
        if (s != null) {
            for (int i = 0; i < s.getStrokes().size(); ++i) {
                List<Coordinate> strokeList = s.getStrokes().get(i);
                for (int j = 1; j < strokeList.size(); ++j) {
                    Coordinate c1 = strokeList.get(j - 1);
                    Coordinate c2 = strokeList.get(j);
                    int x1 = (int)Math.round(c1.getX() * (double)scale);
                    int y1 = (int)Math.round(c1.getY() * (double)scale);
                    int x2 = (int)Math.round(c2.getX() * (double)scale);
                    int y2 = (int)Math.round(c2.getY() * (double)scale);
                    g.drawLine(x1, y1, x2, y2);
                }
            }
        }
        return image;
    }

    public CardSwipe parseCardSwipe(String swipe) throws CardSwipeInvalidException {
        if (swipe == null || swipe.isEmpty()) {
            throw new CardSwipeInvalidException("Card swipe stream is empty.", 0);
        }
        if (swipe.charAt(0) != this.getCardProtocol().getStartStream()) {
            throw new CardSwipeInvalidException("Card swipe stream doesn't start with the correct character (" + swipe.charAt(0) + " != " + this.getCardProtocol().getStartStream() + ")", 0);
        }
        if (swipe.charAt(swipe.length() - 1) != this.getCardProtocol().getEndStream()) {
            throw new CardSwipeInvalidException("Card swipe stream doesn't end with the correct character (" + swipe.charAt(swipe.length() - 1) + " != " + this.getCardProtocol().getEndStream() + ")", 0);
        }
        if (!swipe.substring(1, this.getCardProtocol().getSentinel().length() + 1).equalsIgnoreCase(this.getCardProtocol().getSentinel())) {
            throw new CardSwipeInvalidException("Card swipe stream doesn't start with the correct sentinel.", 1);
        }
        CardSwipe result = new CardSwipe();
        result.setProtocolVersion(swipe.substring(8, 9));
        result.setCardData(swipe.substring(10, swipe.length() - 1));
        result.setFinancialCard(FinancialCard.parse(result.getCardData()));
        result.setIdentificationCard(IdentificationCard.parse(result.getCardData()));
        return result;
    }

    public Signature parseSignature(String sig) throws SignatureInvalidException {
        if (sig == null) {
            throw new SignatureInvalidException("Signature was null", 0);
        }
        if (sig.isEmpty()) {
            throw new SignatureInvalidException("Signature is empty", 0);
        }
        if (sig.charAt(0) != this.signatureProtocol.getStartStream()) {
            throw new SignatureInvalidException("Signature does not start with the start sentinal", 0);
        }
        BatchListener listener = new BatchListener();
        this.addListener(listener);
        for (int i = 0; i < sig.length(); ++i) {
            this.parse(sig.charAt(i));
        }
        this.removeListener(listener);
        if (!listener.isDone()) {
            throw new SignatureInvalidException("No end of signature sentinal found", 0);
        }
        if (listener.isCanceled()) {
            return null;
        }
        return new Signature(this.metadata, listener.getStrokes());
    }

    public void parse(char chr) throws SignatureInvalidException {
        try {
            ++this.currentPosition;
            switch (this.currentState) {
                case UNKNOWN: {
                    if (chr == this.signatureProtocol.getStartStream()) {
                        this.currentState = EasyScriptStreamingState.SIGNATURE_SENTINEL;
                        this.currentPosition = 1;
                        this.signatureBuffer.setLength(0);
                        this.intercepting = true;
                        break;
                    }
                    if (chr != this.cardProtocol.getStartStream()) break;
                    this.currentState = EasyScriptStreamingState.CARD_SENTINEL;
                    this.currentPosition = 1;
                    this.cardBuffer.setLength(0);
                    this.cardBuffer.append(chr);
                    this.cardState = EasyScriptCardState.UNKNOWN;
                    break;
                }
                case CARD_SENTINEL: {
                    EasyScriptCardState state = this.parseCard(chr);
                    if (state != EasyScriptCardState.CARD_PROCESSED && state != EasyScriptCardState.NOT_A_CARD) break;
                    this.cardState = EasyScriptCardState.UNKNOWN;
                    this.currentState = EasyScriptStreamingState.UNKNOWN;
                    this.intercepting = false;
                    break;
                }
                case SIGNATURE_SENTINEL: {
                    if (chr == this.signatureProtocol.getPenUp()) {
                        if (this.signatureBuffer.toString().equals(this.signatureProtocol.getSentinel())) {
                            this.currentState = EasyScriptStreamingState.PROTOCOL_VERSION;
                            this.signatureBuffer.setLength(0);
                            this.metadata = new SignatureMetaData();
                            break;
                        }
                        this.intercepting = false;
                        throw new SignatureInvalidException("Signature sentinel doesn't appear to be correct: " + this.signatureBuffer.toString(), this.currentPosition);
                    }
                    this.signatureBuffer.append(chr);
                    break;
                }
                case PROTOCOL_VERSION: {
                    if (chr == this.signatureProtocol.getPenUp()) {
                        this.metadata.setProtocolVersion(this.signatureBuffer.toString());
                        this.currentState = EasyScriptStreamingState.MODEL;
                        this.signatureBuffer.setLength(0);
                        break;
                    }
                    this.signatureBuffer.append(chr);
                    break;
                }
                case MODEL: {
                    if (chr == this.signatureProtocol.getPenUp()) {
                        this.metadata.setModel(this.signatureBuffer.toString());
                        this.signatureBuffer.setLength(0);
                        this.currentState = EasyScriptStreamingState.FIRMWARE_VERSION;
                        break;
                    }
                    this.signatureBuffer.append(chr);
                    break;
                }
                case FIRMWARE_VERSION: {
                    if (chr == this.signatureProtocol.getPenUp() || chr == this.signatureProtocol.getCancel() || chr == this.signatureProtocol.getEndStream()) {
                        this.metadata.setVersion(this.signatureBuffer.toString());
                        this.signatureBuffer.setLength(0);
                        if (!this.metadata.getProtocolVersion().isEmpty()) {
                            this.metadata.setProtocolVersion(this.metadata.getProtocolVersion().substring(0, 1));
                        }
                        for (EasyScriptEventListener r : this.eventListeners) {
                            r.signatureMetaData(this.metadata);
                        }
                        if (chr == this.signatureProtocol.getEndStream()) {
                            for (EasyScriptEventListener r : this.eventListeners) {
                                r.endOfSignature();
                            }
                            break;
                        }
                        if (chr == this.signatureProtocol.getCancel()) {
                            for (EasyScriptEventListener r : this.eventListeners) {
                                r.cancel();
                            }
                            break;
                        }
                        if ("A".equals(this.metadata.getProtocolVersion()) || "B".equals(this.metadata.getProtocolVersion()) || "C".equals(this.metadata.getProtocolVersion())) {
                            this.currentState = EasyScriptStreamingState.SIGNATURE_UNCOMPRESSED;
                            this.decoder = new EasyScriptUncompressedDecoder(this.signatureProtocol, this.currentPosition, this.eventListeners);
                            break;
                        }
                        if ("D".equals(this.metadata.getProtocolVersion()) || "E".equals(this.metadata.getProtocolVersion())) {
                            this.currentState = EasyScriptStreamingState.SIGNATURE_COMPRESSED;
                            this.decoder = new EasyScriptCompressedDecoder(this.signatureProtocol, this.currentPosition, this.eventListeners);
                            break;
                        }
                        this.intercepting = false;
                        throw new SignatureInvalidException("Unrecognized protocol version: " + this.signatureBuffer, this.currentPosition);
                    }
                    this.signatureBuffer.append(chr);
                    break;
                }
                case SIGNATURE_UNCOMPRESSED: 
                case SIGNATURE_COMPRESSED: {
                    if (chr == this.signatureProtocol.getStartStream()) {
                        for (EasyScriptEventListener r : this.eventListeners) {
                            r.cancel();
                        }
                        this.currentState = EasyScriptStreamingState.UNKNOWN;
                        this.signatureBuffer.setLength(0);
                        this.parse(chr);
                        break;
                    }
                    if (chr == this.cardProtocol.getStartStream() && this.cardState != EasyScriptCardState.NOT_A_CARD) {
                        this.currentState = this.currentState == EasyScriptStreamingState.SIGNATURE_UNCOMPRESSED ? EasyScriptStreamingState.CARD_INTERRUPTING_UNCOMPRESSED : EasyScriptStreamingState.CARD_INTERRUPTING_COMPRESSED;
                        this.cardState = EasyScriptCardState.UNKNOWN;
                        this.cardBuffer.setLength(0);
                        this.cardBuffer.append(chr);
                        break;
                    }
                    this.decoder.parseSignature(chr);
                    break;
                }
                case CARD_INTERRUPTING_UNCOMPRESSED: 
                case CARD_INTERRUPTING_COMPRESSED: {
                    EasyScriptCardState state = this.parseCard(chr);
                    if (state == EasyScriptCardState.NOT_A_CARD) {
                        this.currentState = this.currentState == EasyScriptStreamingState.CARD_INTERRUPTING_UNCOMPRESSED ? EasyScriptStreamingState.SIGNATURE_UNCOMPRESSED : EasyScriptStreamingState.SIGNATURE_COMPRESSED;
                        for (int i = 0; i < this.cardBuffer.length(); ++i) {
                            this.parse(this.cardBuffer.charAt(i));
                        }
                        this.cardState = EasyScriptCardState.UNKNOWN;
                        this.cardBuffer.setLength(0);
                        break;
                    }
                    if (state != EasyScriptCardState.CARD_PROCESSED) break;
                    this.currentState = this.currentState == EasyScriptStreamingState.CARD_INTERRUPTING_UNCOMPRESSED ? EasyScriptStreamingState.SIGNATURE_UNCOMPRESSED : EasyScriptStreamingState.SIGNATURE_COMPRESSED;
                    break;
                }
            }
        }
        catch (SignatureInvalidException e) {
            this.currentState = EasyScriptStreamingState.UNKNOWN;
            throw e;
        }
    }

    private EasyScriptCardState parseCard(char chr) throws CardSwipeInvalidException {
        this.cardBuffer.append(chr);
        switch (this.cardState) {
            case UNKNOWN: {
                if (chr == this.cardProtocol.getSentinel().charAt(this.cardBuffer.length() - 2)) {
                    this.cardState = EasyScriptCardState.CARD_DATA;
                    return EasyScriptCardState.CARD_DATA;
                }
                this.cardState = EasyScriptCardState.NOT_A_CARD;
                return EasyScriptCardState.NOT_A_CARD;
            }
            case CARD_DATA: {
                if (chr != this.cardProtocol.getEndStream()) break;
                CardSwipe swipe = this.parseCardSwipe(this.cardBuffer.toString());
                for (EasyScriptEventListener r : this.eventListeners) {
                    r.cardSwipe(swipe);
                }
                this.cardState = EasyScriptCardState.CARD_PROCESSED;
                return EasyScriptCardState.CARD_PROCESSED;
            }
            default: {
                return EasyScriptCardState.UNKNOWN;
            }
        }
        return EasyScriptCardState.UNKNOWN;
    }

    public void parse(KeyEvent evt) throws SignatureInvalidException {
        Character c;
        if (evt.getID() == 401 && (c = this.keyboardEventToChar(evt)) != null) {
            this.parse(c.charValue());
        }
    }

    public SignatureProtocol getSignatureProtocol() {
        return this.signatureProtocol;
    }

    public CardSwipeProtocol getCardProtocol() {
        return this.cardProtocol;
    }

    public void addListener(EasyScriptEventListener cr) {
        this.eventListeners.add(cr);
    }

    public void removeListener(EasyScriptEventListener cr) {
        this.eventListeners.remove(cr);
    }

    private long getScancode(KeyEvent evt) {
        String s = evt.toString();
        String scancodeConst = "scancode=";
        int begin = s.indexOf("scancode=");
        if (begin < 0) {
            return 0L;
        }
        int end = s.indexOf(44, begin += "scancode=".length());
        if (end < 0) {
            end = s.length();
        }
        s = s.substring(begin, end);
        return Long.parseLong(s);
    }

    private Character keyboardEventToChar(KeyEvent evt) throws SignatureInvalidException {
        boolean shift = evt.isShiftDown();
        long scancode = this.getScancode(evt);
        if (scancode != 0L) {
            if (scancode < Integer.MIN_VALUE || scancode > Integer.MAX_VALUE) {
                return null;
            }
            switch ((int)scancode) {
                case 41: {
                    return Character.valueOf(!shift ? (char)'`' : '~');
                }
                case 11: {
                    return Character.valueOf(!shift ? (char)'0' : ')');
                }
                case 2: {
                    return Character.valueOf(!shift ? (char)'1' : '!');
                }
                case 3: {
                    return Character.valueOf(!shift ? (char)'2' : '@');
                }
                case 4: {
                    return Character.valueOf(!shift ? (char)'3' : '#');
                }
                case 5: {
                    return Character.valueOf(!shift ? (char)'4' : '$');
                }
                case 6: {
                    return Character.valueOf(!shift ? (char)'5' : '%');
                }
                case 7: {
                    return Character.valueOf(!shift ? (char)'6' : '^');
                }
                case 8: {
                    return Character.valueOf(!shift ? (char)'7' : '&');
                }
                case 9: {
                    return Character.valueOf(!shift ? (char)'8' : '*');
                }
                case 10: {
                    return Character.valueOf(!shift ? (char)'9' : '(');
                }
                case 12: {
                    return Character.valueOf(!shift ? (char)'-' : '_');
                }
                case 13: {
                    return Character.valueOf(!shift ? (char)'=' : '+');
                }
                case 16: {
                    return Character.valueOf(!shift ? (char)'q' : 'Q');
                }
                case 17: {
                    return Character.valueOf(!shift ? (char)'w' : 'W');
                }
                case 18: {
                    return Character.valueOf(!shift ? (char)'e' : 'E');
                }
                case 19: {
                    return Character.valueOf(!shift ? (char)'r' : 'R');
                }
                case 20: {
                    return Character.valueOf(!shift ? (char)'t' : 'T');
                }
                case 21: {
                    return Character.valueOf(!shift ? (char)'y' : 'Y');
                }
                case 22: {
                    return Character.valueOf(!shift ? (char)'u' : 'U');
                }
                case 23: {
                    return Character.valueOf(!shift ? (char)'i' : 'I');
                }
                case 24: {
                    return Character.valueOf(!shift ? (char)'o' : 'O');
                }
                case 25: {
                    return Character.valueOf(!shift ? (char)'p' : 'P');
                }
                case 26: {
                    return Character.valueOf(!shift ? (char)'[' : '{');
                }
                case 27: {
                    return Character.valueOf(!shift ? (char)']' : '}');
                }
                case 43: {
                    return Character.valueOf(!shift ? (char)'\\' : '|');
                }
                case 30: {
                    return Character.valueOf(!shift ? (char)'a' : 'A');
                }
                case 31: {
                    return Character.valueOf(!shift ? (char)'s' : 'S');
                }
                case 32: {
                    return Character.valueOf(!shift ? (char)'d' : 'D');
                }
                case 33: {
                    return Character.valueOf(!shift ? (char)'f' : 'F');
                }
                case 34: {
                    return Character.valueOf(!shift ? (char)'g' : 'G');
                }
                case 35: {
                    return Character.valueOf(!shift ? (char)'h' : 'H');
                }
                case 36: {
                    return Character.valueOf(!shift ? (char)'j' : 'J');
                }
                case 37: {
                    return Character.valueOf(!shift ? (char)'k' : 'K');
                }
                case 38: {
                    return Character.valueOf(!shift ? (char)'l' : 'L');
                }
                case 39: {
                    return Character.valueOf(!shift ? (char)';' : ':');
                }
                case 40: {
                    return Character.valueOf(!shift ? (char)'\'' : '\"');
                }
                case 44: {
                    return Character.valueOf(!shift ? (char)'z' : 'Z');
                }
                case 45: {
                    return Character.valueOf(!shift ? (char)'x' : 'X');
                }
                case 46: {
                    return Character.valueOf(!shift ? (char)'c' : 'C');
                }
                case 47: {
                    return Character.valueOf(!shift ? (char)'v' : 'V');
                }
                case 48: {
                    return Character.valueOf(!shift ? (char)'b' : 'B');
                }
                case 49: {
                    return Character.valueOf(!shift ? (char)'n' : 'N');
                }
                case 50: {
                    return Character.valueOf(!shift ? (char)'m' : 'M');
                }
                case 51: {
                    return Character.valueOf(!shift ? (char)',' : '<');
                }
                case 52: {
                    return Character.valueOf(!shift ? (char)'.' : '>');
                }
                case 53: {
                    return Character.valueOf(!shift ? (char)'/' : '?');
                }
                case 28: {
                    return Character.valueOf('\r');
                }
                case 57: {
                    return Character.valueOf(' ');
                }
            }
            return null;
        }
        switch (evt.getKeyCode()) {
            case 192: {
                return Character.valueOf(!shift ? (char)'`' : '~');
            }
            case 49: {
                return Character.valueOf(!shift ? (char)'1' : '!');
            }
            case 50: {
                return Character.valueOf(!shift ? (char)'2' : '@');
            }
            case 51: {
                return Character.valueOf(!shift ? (char)'3' : '#');
            }
            case 52: {
                return Character.valueOf(!shift ? (char)'4' : '$');
            }
            case 53: {
                return Character.valueOf(!shift ? (char)'5' : '%');
            }
            case 54: {
                return Character.valueOf(!shift ? (char)'6' : '^');
            }
            case 55: {
                return Character.valueOf(!shift ? (char)'7' : '&');
            }
            case 56: {
                return Character.valueOf(!shift ? (char)'8' : '*');
            }
            case 57: {
                return Character.valueOf(!shift ? (char)'9' : '(');
            }
            case 48: {
                return Character.valueOf(!shift ? (char)'0' : ')');
            }
            case 45: {
                return Character.valueOf(!shift ? (char)'-' : '_');
            }
            case 61: {
                return Character.valueOf(!shift ? (char)'=' : '+');
            }
            case 81: {
                return Character.valueOf(!shift ? (char)'q' : 'Q');
            }
            case 87: {
                return Character.valueOf(!shift ? (char)'w' : 'W');
            }
            case 69: {
                return Character.valueOf(!shift ? (char)'e' : 'E');
            }
            case 82: {
                return Character.valueOf(!shift ? (char)'r' : 'R');
            }
            case 84: {
                return Character.valueOf(!shift ? (char)'t' : 'T');
            }
            case 89: {
                return Character.valueOf(!shift ? (char)'y' : 'Y');
            }
            case 85: {
                return Character.valueOf(!shift ? (char)'u' : 'U');
            }
            case 73: {
                return Character.valueOf(!shift ? (char)'i' : 'I');
            }
            case 79: {
                return Character.valueOf(!shift ? (char)'o' : 'O');
            }
            case 80: {
                return Character.valueOf(!shift ? (char)'p' : 'P');
            }
            case 91: {
                return Character.valueOf(!shift ? (char)'[' : '{');
            }
            case 93: {
                return Character.valueOf(!shift ? (char)']' : '}');
            }
            case 92: {
                return Character.valueOf(!shift ? (char)'\\' : '|');
            }
            case 65: {
                return Character.valueOf(!shift ? (char)'a' : 'A');
            }
            case 83: {
                return Character.valueOf(!shift ? (char)'s' : 'S');
            }
            case 68: {
                return Character.valueOf(!shift ? (char)'d' : 'D');
            }
            case 70: {
                return Character.valueOf(!shift ? (char)'f' : 'F');
            }
            case 71: {
                return Character.valueOf(!shift ? (char)'g' : 'G');
            }
            case 72: {
                return Character.valueOf(!shift ? (char)'h' : 'H');
            }
            case 74: {
                return Character.valueOf(!shift ? (char)'j' : 'J');
            }
            case 75: {
                return Character.valueOf(!shift ? (char)'k' : 'K');
            }
            case 76: {
                return Character.valueOf(!shift ? (char)'l' : 'L');
            }
            case 59: {
                return Character.valueOf(!shift ? (char)';' : ':');
            }
            case 222: {
                return Character.valueOf(!shift ? (char)'\'' : '\"');
            }
            case 90: {
                return Character.valueOf(!shift ? (char)'z' : 'Z');
            }
            case 88: {
                return Character.valueOf(!shift ? (char)'x' : 'X');
            }
            case 67: {
                return Character.valueOf(!shift ? (char)'c' : 'C');
            }
            case 86: {
                return Character.valueOf(!shift ? (char)'v' : 'V');
            }
            case 66: {
                return Character.valueOf(!shift ? (char)'b' : 'B');
            }
            case 78: {
                return Character.valueOf(!shift ? (char)'n' : 'N');
            }
            case 77: {
                return Character.valueOf(!shift ? (char)'m' : 'M');
            }
            case 44: {
                return Character.valueOf(!shift ? (char)',' : '<');
            }
            case 46: {
                return Character.valueOf(!shift ? (char)'.' : '>');
            }
            case 47: {
                return Character.valueOf(!shift ? (char)'/' : '?');
            }
            case 32: {
                return Character.valueOf(' ');
            }
            case 10: {
                return Character.valueOf('\r');
            }
        }
        return null;
    }

    private class BatchListener
    implements EasyScriptEventListener {
        private final List<List<Coordinate>> strokes = new LinkedList<List<Coordinate>>();
        private List<Coordinate> stroke;
        private CardSwipe swipe;
        private boolean done = false;
        private boolean canceled = false;

        private BatchListener() {
        }

        public List<List<Coordinate>> getStrokes() {
            return this.strokes;
        }

        public CardSwipe getSwipe() {
            return this.swipe;
        }

        public boolean isDone() {
            return this.done;
        }

        public boolean isCanceled() {
            return this.canceled;
        }

        @Override
        public void receiveCoordinate(Coordinate coordinate) {
            this.stroke.add(coordinate);
        }

        @Override
        public void newStroke() {
            this.stroke = new LinkedList<Coordinate>();
            this.strokes.add(this.stroke);
        }

        @Override
        public void cancel() {
            this.canceled = true;
            this.done = true;
        }

        @Override
        public void endOfSignature() {
            this.done = true;
        }

        @Override
        public void signatureMetaData(SignatureMetaData md) {
            EasyScript.this.metadata = md;
        }

        @Override
        public void cardSwipe(CardSwipe swipe) {
            this.swipe = swipe;
        }
    }

    private class EndOfStreamListener
    implements EasyScriptEventListener {
        private EndOfStreamListener() {
        }

        @Override
        public void receiveCoordinate(Coordinate coordinate) {
        }

        @Override
        public void newStroke() {
        }

        @Override
        public void cancel() {
            EasyScript.this.currentState = EasyScriptStreamingState.UNKNOWN;
            EasyScript.this.intercepting = false;
        }

        @Override
        public void endOfSignature() {
            EasyScript.this.currentState = EasyScriptStreamingState.UNKNOWN;
            EasyScript.this.intercepting = false;
        }

        @Override
        public void signatureMetaData(SignatureMetaData header) {
        }

        @Override
        public void cardSwipe(CardSwipe swipe) {
        }
    }
}

